/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.validation;

import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.interfaces.Employee;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class CloseConnAfterDatabaseSessionTxnTest
extends AutoVerifyTestCase {
    protected DatabaseSession session = null;

    public CloseConnAfterDatabaseSessionTxnTest() {
        this.setDescription("Ensure the connection closed properly once query finished - DatabaseSession has no ExternalTransactionController");
    }

    public void setup() {
        EmployeeProject project = new EmployeeProject();
        DatasourceLogin clonedLogin = (DatasourceLogin)this.getSession().getProject().getDatasourceLogin().clone();
        project.setLogin((Login)clonedLogin);
        clonedLogin.useExternalConnectionPooling();
        this.session = project.createDatabaseSession();
        this.session.login();
    }

    public void test() {
        EmployeePopulator system = new EmployeePopulator();
        Employee employee = system.basicEmployeeExample1();
        this.session.insertObject((Object)employee);
        this.session.deleteObject((Object)employee);
    }

    public void verify() {
        if (((AbstractSession)this.session).getAccessor().getDatasourceConnection() != null) {
            throw new TestErrorException("The connection expected to close which still open after a txn was finished.");
        }
    }

    public void reset() {
        this.session.logout();
    }
}

