/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.partitioning;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class RangePartition {
    protected String endValueName;
    protected String startValueName;
    protected String partitionValueTypeName;
    protected String connectionPool;
    protected Class partitionValueType;
    protected Comparable startValue;
    protected Comparable endValue;

    public RangePartition() {
    }

    public RangePartition(String connectionPool, String partitionValueTypeName, String startValueName, String endValueName) {
        this.connectionPool = connectionPool;
        this.endValue = null;
        this.endValueName = endValueName;
        this.startValue = null;
        this.startValueName = startValueName;
        this.partitionValueTypeName = partitionValueTypeName;
    }

    public RangePartition(String connectionPool, Comparable startValue, Comparable endValue) {
        this.connectionPool = connectionPool;
        this.startValue = startValue;
        this.endValue = endValue;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        if (this.partitionValueType == null && this.partitionValueTypeName != null) {
            this.partitionValueType = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.partitionValueTypeName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.partitionValueTypeName, ex));
        }
        if (this.partitionValueType != null) {
            if (this.startValueName != null) {
                this.startValue = (Comparable)this.initObject(this.partitionValueType, this.startValueName);
            }
            if (this.endValueName != null) {
                this.endValue = (Comparable)this.initObject(this.partitionValueType, this.endValueName);
            }
        }
    }

    public Comparable getStartValue() {
        return this.startValue;
    }

    protected Object initObject(Class<?> type, String value) {
        try {
            return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeConstructor(PrivilegedAccessHelper.getConstructorFor(type, new Class[]{String.class}, false), new Object[]{value}));
        }
        catch (Exception exception) {
            return value;
        }
    }

    public void setStartValue(Comparable startValue) {
        this.startValue = startValue;
    }

    public Comparable getEndValue() {
        return this.endValue;
    }

    public void setEndValue(Comparable endValue) {
        this.endValue = endValue;
    }

    public String getConnectionPool() {
        return this.connectionPool;
    }

    public void setConnectionPool(String connectionPool) {
        this.connectionPool = connectionPool;
    }

    public boolean isInRange(Object value) {
        if (this.startValue != null && this.startValue.compareTo(value) > 0) {
            return false;
        }
        return this.endValue == null || this.endValue.compareTo(value) >= 0;
    }
}

