/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.Type;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.CollectionMapping;

public abstract class PluralAttributeImpl<X, C, V>
extends AttributeImpl<X, C>
implements PluralAttribute<X, C, V> {
    private Type<V> elementType;

    protected PluralAttributeImpl(ManagedTypeImpl<X> managedType, CollectionMapping mapping, boolean validationEnabled) {
        super(managedType, mapping);
        ClassDescriptor elementDesc = mapping.getContainerPolicy().getElementDescriptor();
        if (elementDesc != null && !mapping.isMapKeyMapping() && !mapping.isDirectMapMapping()) {
            this.elementType = this.getMetamodel().getType(elementDesc.getJavaClass());
        } else {
            Class attributeClass = null;
            if (mapping.isDirectCollectionMapping() || mapping.isAbstractCompositeDirectCollectionMapping() || mapping.isDirectCollectionMapping()) {
                attributeClass = mapping.getAttributeClassification();
                if (null == attributeClass) {
                    AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_unable_to_determine_element_type_in_absence_of_generic_parameters", (Object)this);
                }
            } else if (mapping.isMapKeyMapping()) {
                ContainerPolicy policy = mapping.getContainerPolicy();
                if (policy.isMapPolicy()) {
                    MapContainerPolicy mapPolicy = (MapContainerPolicy)mapping.getContainerPolicy();
                    attributeClass = mapPolicy.getElementClass();
                } else {
                    attributeClass = managedType.getJavaType();
                }
            } else if (mapping.isManyToManyMapping() || mapping.isOneToManyMapping()) {
                attributeClass = mapping.getReferenceClass();
            } else if (mapping.isAggregateCollectionMapping()) {
                attributeClass = mapping.getReferenceClass();
            }
            if (null == attributeClass && validationEnabled) {
                attributeClass = Object.class;
                AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_attribute_class_type_is_null", (Object)this);
            }
            this.elementType = this.getMetamodel().getType(attributeClass);
        }
    }

    public Class<V> getBindableJavaType() {
        return this.elementType.getJavaType();
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.PLURAL_ATTRIBUTE;
    }

    public CollectionMapping getCollectionMapping() {
        return (CollectionMapping)this.getMapping();
    }

    public abstract PluralAttribute.CollectionType getCollectionType();

    public Type<V> getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isPlural() {
        return true;
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer(this.getJavaType().getSimpleName());
        aBuffer.append("AttributeImpl[");
        aBuffer.append(this.getMapping());
        aBuffer.append("]");
        return aBuffer.toString();
    }
}

