/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.serializers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.persistence.internal.helper.CustomObjectInputStream;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.serializers.AbstractSerializer;

public class JavaSerializer
extends AbstractSerializer {
    public static final JavaSerializer instance = new JavaSerializer();

    @Override
    public Object serialize(Object object, Session session) {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOut = new ObjectOutputStream(byteOut);
            objectOut.writeObject(object);
            objectOut.flush();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return byteOut.toByteArray();
    }

    @Override
    public Class getType() {
        return byte[].class;
    }

    @Override
    public Object deserialize(Object bytes, Session session) {
        Object object;
        block8: {
            ByteArrayInputStream byteIn = new ByteArrayInputStream((byte[])bytes);
            ObjectInputStream objectIn = session == null ? new ObjectInputStream(byteIn) : new CustomObjectInputStream(byteIn, session);
            try {
                object = objectIn.readObject();
                if (objectIn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | ClassNotFoundException exception) {
                    throw new RuntimeException(exception);
                }
            }
            objectIn.close();
        }
        return object;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }
}

