/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import oracle.kv.impl.api.table.BinaryDefImpl;
import oracle.kv.impl.api.table.BooleanDefImpl;
import oracle.kv.impl.api.table.DoubleDefImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefFactory;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.impl.api.table.FloatDefImpl;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.IntegerDefImpl;
import oracle.kv.impl.api.table.JsonDefImpl;
import oracle.kv.impl.api.table.LongDefImpl;
import oracle.kv.impl.api.table.NumberDefImpl;
import oracle.kv.impl.api.table.RecordBuilder;
import oracle.kv.impl.api.table.SequenceDefImpl;
import oracle.kv.impl.api.table.StringDefImpl;
import oracle.kv.impl.api.table.TableBuilder;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableLimits;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.security.ResourceOwner;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.table.FieldDef;
import oracle.kv.table.Index;
import oracle.kv.table.SequenceDef;
import oracle.kv.table.Table;
import oracle.kv.table.TimeToLive;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableJsonUtils
extends JsonUtils {
    static final String PARENT = "parent";
    static final String OWNER = "owner";
    static final String SHARDKEY = "shardKey";
    static final String PRIMARYKEY = "primaryKey";
    static final String CHILDREN = "children";
    static final String FIELDS = "fields";
    static final String JSON_VERSION = "json_version";
    static final String R2COMPAT = "r2compat";
    static final String CHILDTABLES = "childTables";
    static final String SYSTABLE = "sysTable";
    static final String DESC = "comment";
    static final String NULLABLE = "nullable";
    static final String MIN = "min";
    static final String MAX = "max";
    static final String MIN_INCL = "min_inclusive";
    static final String MAX_INCL = "max_inclusive";
    static final String COLLECTION = "collection";
    static final String ENUM_NAME = "enum_name";
    static final String TTL = "ttl";
    static final String PKEY_SIZES = "primaryKeySizes";
    static final String INDEXES = "indexes";
    static final String ANNOTATIONS = "annotations";
    static final String PROPERTIES = "properties";
    static final String TABLE = "table";
    static final String NAME = "name";
    static final String NAMESPACE = "namespace";
    static final String TYPE = "type";
    static final String TYPES = "types";
    static final String DEFAULT = "default";
    static final String ENUM_VALS = "symbols";
    static final String NULL = "null";
    static final String IDENTITY = "identity";
    static final String ALWAYS = "always";
    static final String SEQUENCE = "sequence";
    static final String START = "start";
    static final String INCREMENT = "increment";
    static final String CACHE = "cache";
    static final String CYCLE = "cycle";
    static final String RECORD = "record";
    static final String ENUM = "enum";
    static final String ARRAY = "array";
    static final String MAP = "map";
    static final String INT = "int";
    static final String LONG = "long";
    static final String STRING = "string";
    static final String BOOLEAN = "boolean";
    static final String DOUBLE = "double";
    static final String FLOAT = "float";
    static final String BYTES = "bytes";
    static final String FIXED = "fixed";
    static final String FIXED_SIZE = "size";
    static final String TIMESTAMP = "timestamp";
    static final String TIMESTAMP_PRECISION = "precision";
    private static final DecoderFactory decoderFactory = DecoderFactory.get();
    private static final EncoderFactory encoderFactory = EncoderFactory.get();

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    static JsonFactory getJsonFactory() {
        return mapper.getJsonFactory();
    }

    static DecoderFactory getDecoderFactory() {
        return decoderFactory;
    }

    static EncoderFactory getEncoderFactory() {
        return encoderFactory;
    }

    public static String encodeBase64(byte[] buf) {
        return mapper.convertValue((Object)buf, String.class);
    }

    public static byte[] decodeBase64(String str) {
        return mapper.convertValue((Object)str, byte[].class);
    }

    static FieldDefImpl fromJson(ObjectNode node) {
        String nameString = TableJsonUtils.getStringFromNode(node, NAME, false);
        String descString = TableJsonUtils.getStringFromNode(node, DESC, false);
        String minString = TableJsonUtils.getStringFromNode(node, MIN, false);
        String maxString = TableJsonUtils.getStringFromNode(node, MAX, false);
        String sizeString = TableJsonUtils.getStringFromNode(node, FIXED_SIZE, false);
        String typeString = TableJsonUtils.getStringFromNode(node, TYPE, true);
        String precisionString = TableJsonUtils.getStringFromNode(node, TIMESTAMP_PRECISION, false);
        FieldDef.Type type = FieldDef.Type.valueOf(typeString.toUpperCase());
        switch (type) {
            case INTEGER: {
                if (descString == null && minString == null && maxString == null) {
                    return FieldDefImpl.integerDef;
                }
                return new IntegerDefImpl(descString, minString != null ? Integer.valueOf(minString) : null, maxString != null ? Integer.valueOf(maxString) : null);
            }
            case LONG: {
                if (descString == null && minString == null && maxString == null) {
                    return FieldDefImpl.longDef;
                }
                return new LongDefImpl(descString, minString != null ? Long.valueOf(minString) : null, maxString != null ? Long.valueOf(maxString) : null);
            }
            case DOUBLE: {
                if (descString == null && minString == null && maxString == null) {
                    return FieldDefImpl.doubleDef;
                }
                return new DoubleDefImpl(descString, minString != null ? Double.valueOf(minString) : null, maxString != null ? Double.valueOf(maxString) : null);
            }
            case FLOAT: {
                if (descString == null && minString == null && maxString == null) {
                    return FieldDefImpl.floatDef;
                }
                return new FloatDefImpl(descString, minString != null ? Float.valueOf(minString) : null, maxString != null ? Float.valueOf(maxString) : null);
            }
            case STRING: {
                if (descString == null && minString == null && maxString == null) {
                    return FieldDefImpl.stringDef;
                }
                Boolean minInclusive = TableJsonUtils.getBoolean(node, MIN_INCL);
                Boolean maxInclusive = TableJsonUtils.getBoolean(node, MAX_INCL);
                return new StringDefImpl(descString, minString, maxString, minInclusive, maxInclusive);
            }
            case NUMBER: {
                if (descString == null) {
                    return FieldDefImpl.numberDef;
                }
                return new NumberDefImpl(descString);
            }
            case BINARY: {
                if (descString == null) {
                    return FieldDefImpl.binaryDef;
                }
                return new BinaryDefImpl(descString);
            }
            case FIXED_BINARY: {
                int size = sizeString == null ? 0 : Integer.valueOf(sizeString);
                return new FixedBinaryDefImpl(nameString, size, descString);
            }
            case BOOLEAN: {
                if (descString == null) {
                    return FieldDefImpl.booleanDef;
                }
                return new BooleanDefImpl(descString);
            }
            case TIMESTAMP: {
                int precision = precisionString == null ? 9 : Integer.valueOf(precisionString);
                return new TimestampDefImpl(precision, descString);
            }
            case ARRAY: 
            case MAP: {
                JsonNode jnode = node.get(COLLECTION);
                if (jnode == null) {
                    throw new IllegalArgumentException("Map and Array require a collection object");
                }
                FieldDefImpl elementDef = TableJsonUtils.fromJson((ObjectNode)jnode);
                if (type == FieldDef.Type.ARRAY) {
                    return FieldDefFactory.createArrayDef(elementDef, descString);
                }
                return FieldDefFactory.createMapDef(elementDef, descString);
            }
            case RECORD: {
                JsonNode fieldsNode = node.get(FIELDS);
                if (fieldsNode == null) {
                    throw new IllegalArgumentException("Record is missing fields object");
                }
                RecordBuilder builder = TableBuilder.createRecordBuilder(nameString, descString);
                ArrayNode arrayNode = (ArrayNode)fieldsNode;
                for (int i = 0; i < arrayNode.size(); ++i) {
                    ObjectNode o = (ObjectNode)arrayNode.get(i);
                    String fieldName = TableJsonUtils.getStringFromNode(o, NAME, true);
                    builder.fromJson(fieldName, o);
                }
                try {
                    return (FieldDefImpl)((Object)builder.build());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Failed to build record from JSON, field name: " + nameString);
                }
            }
            case ENUM: {
                JsonNode valuesNode = node.get(ENUM_VALS);
                if (valuesNode == null) {
                    throw new IllegalArgumentException("Enumeration is missing values");
                }
                ArrayNode arrayNode = (ArrayNode)valuesNode;
                String enumName = TableJsonUtils.getStringFromNode(node, ENUM_NAME, true);
                String[] values = new String[arrayNode.size()];
                for (int i = 0; i < arrayNode.size(); ++i) {
                    values[i] = arrayNode.get(i).asText();
                }
                return new EnumDefImpl(enumName, values, descString);
            }
            case JSON: {
                if (descString == null) {
                    return FieldDefImpl.jsonDef;
                }
                return new JsonDefImpl(descString);
            }
            case ANY: {
                return FieldDefImpl.anyDef;
            }
            case ANY_ATOMIC: {
                return FieldDefImpl.anyAtomicDef;
            }
            case ANY_RECORD: {
                return FieldDefImpl.anyRecordDef;
            }
            case ANY_JSON_ATOMIC: {
                return FieldDefImpl.anyJsonAtomicDef;
            }
        }
        throw new IllegalArgumentException("Cannot construct FieldDef type from JSON: " + type);
    }

    static void indexFromJsonNode(ObjectNode node, TableImpl table) {
        ArrayNode fields = (ArrayNode)node.get(FIELDS);
        ArrayList<String> fieldStrings = new ArrayList<String>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            fieldStrings.add(fields.get(i).asText());
        }
        ArrayList<FieldDef.Type> typeStrings = null;
        ArrayNode types = (ArrayNode)node.get(TYPES);
        if (types != null) {
            typeStrings = new ArrayList<FieldDef.Type>(types.size());
            for (int i = 0; i < fields.size(); ++i) {
                JsonNode typeNode = types.get(i);
                if (typeNode.isNull()) {
                    typeStrings.add(null);
                    continue;
                }
                typeStrings.add(FieldDef.Type.valueOf(typeNode.asText()));
            }
        }
        String name = TableJsonUtils.getStringFromNode(node, NAME, true);
        String desc = TableJsonUtils.getStringFromNode(node, DESC, false);
        Map<String, String> annotations = TableJsonUtils.getMapFromNode(node, ANNOTATIONS);
        Map<String, String> properties = TableJsonUtils.getMapFromNode(node, PROPERTIES);
        table.addIndex(new IndexImpl(name, table, fieldStrings, typeStrings, annotations, properties, desc));
    }

    public static TableImpl fromJsonString(String jsonString, TableImpl parent) {
        JsonNode rootNode = null;
        try {
            rootNode = TableJsonUtils.getObjectMapper().readTree(jsonString);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("IOException parsing Json: " + ioe);
        }
        return TableJsonUtils.fromJson(rootNode, parent);
    }

    private static TableImpl fromJson(JsonNode rootNode, TableImpl parent) {
        int i;
        String namespace = rootNode.get(NAMESPACE) != null ? rootNode.get(NAMESPACE).asText() : null;
        TableBuilder tb = null;
        tb = rootNode.get(SYSTABLE) != null ? TableBuilder.createSystemTableBuilder(rootNode.get(NAME).asText()) : TableBuilder.createTableBuilder(namespace, rootNode.get(NAME).asText(), null, parent, true);
        tb.primaryKey(TableJsonUtils.makeListFromArray(rootNode, PRIMARYKEY));
        if (parent == null) {
            tb.shardKey(TableJsonUtils.makeListFromArray(rootNode, SHARDKEY));
        }
        if (rootNode.get(DESC) != null) {
            tb.setDescription(rootNode.get(DESC).asText());
        }
        if (rootNode.get(R2COMPAT) != null) {
            tb.setR2compat(true);
        }
        if (rootNode.get(OWNER) != null && !rootNode.get(OWNER).isNull()) {
            tb.setOwner(ResourceOwner.fromString(rootNode.get(OWNER).asText()));
        }
        if (rootNode.get(TTL) != null) {
            String ttlString = rootNode.get(TTL).asText();
            String[] ttlArray = ttlString.split(" ");
            if (ttlArray.length != 2) {
                throw new IllegalArgumentException("Invalid value for ttl string: " + ttlString);
            }
            tb.setDefaultTTL(TimeToLive.createTimeToLive(Long.parseLong(ttlArray[0]), TimeUnit.valueOf(ttlArray[1])));
        }
        if (rootNode.get(PKEY_SIZES) != null) {
            ArrayNode pks = (ArrayNode)rootNode.get(PKEY_SIZES);
            List<String> pkey = tb.getPrimaryKey();
            assert (pks.size() == pkey.size());
            for (i = 0; i < pks.size(); ++i) {
                int size = pks.get(i).asInt();
                if (size <= 0) continue;
                tb.primaryKeySize(pkey.get(i), size);
            }
        }
        ArrayNode arrayNode = (ArrayNode)rootNode.get(FIELDS);
        for (int i2 = 0; i2 < arrayNode.size(); ++i2) {
            ObjectNode node = (ObjectNode)arrayNode.get(i2);
            String fieldName = TableJsonUtils.getStringFromNode(node, NAME, true);
            if (parent != null && parent.isKeyComponent(fieldName)) continue;
            tb.fromJson(fieldName, node);
        }
        TableImpl newTable = tb.buildTable();
        if (rootNode.get(INDEXES) != null) {
            arrayNode = (ArrayNode)rootNode.get(INDEXES);
            for (i = 0; i < arrayNode.size(); ++i) {
                ObjectNode node = (ObjectNode)arrayNode.get(i);
                TableJsonUtils.indexFromJsonNode(node, newTable);
            }
        }
        if (rootNode.get(CHILDTABLES) != null) {
            arrayNode = (ArrayNode)rootNode.get(CHILDTABLES);
            for (i = 0; i < arrayNode.size(); ++i) {
                ObjectNode node = (ObjectNode)arrayNode.get(i);
                TableImpl child = TableJsonUtils.fromJson(node, newTable);
                newTable.getMutableChildTables().put(child.getName(), child);
            }
        }
        return newTable;
    }

    static String toJsonString(TableImpl table, boolean pretty, boolean includeChildren) {
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode o = JsonUtils.createObjectNode();
        TableJsonUtils.toJsonString(table, o, includeChildren);
        try {
            return writer.writeValueAsString(o);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
    }

    public static void toJsonString(TableImpl table, ObjectNode o, boolean includeChildren) {
        Map<String, Table> childTables;
        TableLimits limits;
        o.put(JSON_VERSION, 1);
        o.put(TYPE, TABLE);
        o.put(NAME, table.getName());
        if (table.getInternalNamespace() != null) {
            o.put(NAMESPACE, table.getInternalNamespace());
        }
        if (table.getDefaultTTL() != null) {
            o.put(TTL, table.getDefaultTTL().toString());
        }
        if (table.getOwner() != null) {
            o.put(OWNER, table.getOwner().toString());
        }
        if (table.isSystemTable()) {
            o.put(SYSTABLE, true);
        }
        if (table.isR2compatible()) {
            o.put(R2COMPAT, true);
        }
        if (table.getDescription() != null) {
            o.put(DESC, table.getDescription());
        }
        if (table.getParent() != null) {
            o.put(PARENT, table.getParent().getName());
        }
        ArrayNode key = o.putArray(SHARDKEY);
        for (String fieldName : table.getShardKeyInternal()) {
            key.add(fieldName);
        }
        key = o.putArray(PRIMARYKEY);
        for (String fieldName : table.getPrimaryKeyInternal()) {
            key.add(fieldName);
        }
        if (table.getPrimaryKeySizes() != null) {
            key = o.putArray(PKEY_SIZES);
            Iterator<Object> iterator = table.getPrimaryKeySizes().iterator();
            while (iterator.hasNext()) {
                int size = (Integer)iterator.next();
                key.add(size);
            }
        }
        if (table.isTop() && (limits = table.getTableLimits()) != null) {
            limits.putLimits(o);
        }
        if (!(childTables = table.getChildTables()).isEmpty()) {
            ArrayNode childArray = o.putArray(CHILDREN);
            for (Map.Entry<String, Table> entry : childTables.entrySet()) {
                childArray.add(entry.getKey());
            }
        }
        table.getFieldMap().putFields(o);
        Map<String, Index> indexes = table.getIndexes();
        if (indexes.size() != 0) {
            ArrayNode indexArray = o.putArray(INDEXES);
            for (Map.Entry<String, Index> entry : indexes.entrySet()) {
                IndexImpl impl = (IndexImpl)entry.getValue();
                impl.toJsonNode(indexArray.addObject());
            }
        }
        if (!childTables.isEmpty() && includeChildren) {
            ArrayNode childArray = o.putArray(CHILDTABLES);
            for (Map.Entry<String, Table> entry : childTables.entrySet()) {
                ObjectNode cnode = childArray.addObject();
                TableJsonUtils.toJsonString((TableImpl)entry.getValue(), cnode, includeChildren);
            }
        }
        if (table.hasIdentityColumn()) {
            ObjectNode idObj = o.putObject(IDENTITY);
            idObj.put(NAME, table.getFieldMap().getFieldName(table.getIdentityColumn()));
            idObj.put(ALWAYS, table.isIdentityGeneratedAlways());
            idObj.put(NULL, table.isIdentityOnNull());
            SequenceDef sequenceDef = table.getIdentitySequenceDef();
            if (sequenceDef != null) {
                idObj.put(SEQUENCE, ((SequenceDefImpl)sequenceDef).toJsonNode());
            }
        }
    }

    public static BigDecimal jsonParserGetDecimalValue(JsonParser parser) throws IOException {
        assert (parser != null);
        try {
            return parser.getDecimalValue();
        }
        catch (NumberFormatException nfe) {
            throw new JsonParseException("Malformed numeric value: '" + parser.getText(), parser.getCurrentLocation(), nfe);
        }
    }

    private static List<String> makeListFromArray(JsonNode node, String fieldName) {
        ArrayNode arrayNode = (ArrayNode)node.get(fieldName);
        if (arrayNode == null) {
            return null;
        }
        ArrayList<String> keyList = new ArrayList<String>(arrayNode.size());
        for (int i = 0; i < arrayNode.size(); ++i) {
            keyList.add(i, arrayNode.get(i).asText());
        }
        return keyList;
    }

    private static String getStringFromNode(ObjectNode node, String name, boolean required) {
        JsonNode jnode = node.get(name);
        if (jnode != null) {
            return jnode.asText();
        }
        if (required) {
            throw new IllegalArgumentException("Missing required node in JSON table representation: " + name);
        }
        return null;
    }

    private static Map<String, String> getMapFromNode(ObjectNode node, String name) {
        JsonNode jnode = node.get(name);
        if (jnode == null) {
            return null;
        }
        if (!(jnode instanceof ObjectNode)) {
            throw new IllegalArgumentException("Node is not an ObjectNode: " + name);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator<Map.Entry<String, JsonNode>> iter = jnode.getFields();
        while (iter.hasNext()) {
            Map.Entry<String, JsonNode> entry = iter.next();
            map.put(entry.getKey(), entry.getValue().asText());
        }
        return map;
    }
}

