/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.ArrayDefImpl;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.TupleValue;
import oracle.kv.impl.query.QueryException;
import oracle.kv.impl.query.compiler.ExprArrayConstr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class ArrayConstrIter
extends PlanIter {
    private final PlanIter[] theArgs;
    private final ArrayDefImpl theDef;
    private boolean theIsConditional;

    public ArrayConstrIter(ExprArrayConstr e, int resultReg, PlanIter[] args) {
        super(e, resultReg);
        this.theArgs = args;
        this.theDef = e.getArrayType();
        this.theIsConditional = e.isConditional();
    }

    ArrayConstrIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theArgs = ArrayConstrIter.deserializeIters(in, serialVersion);
        this.theDef = (ArrayDefImpl)ArrayConstrIter.deserializeFieldDef(in, serialVersion);
        this.theIsConditional = serialVersion >= 13 ? in.readBoolean() : false;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        ArrayConstrIter.serializeIters(this.theArgs, out, serialVersion);
        ArrayConstrIter.serializeFieldDef(this.theDef, out, serialVersion);
        if (serialVersion >= 13) {
            out.writeBoolean(this.theIsConditional);
        }
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.ARRAY_CONSTR;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        for (PlanIter arg : this.theArgs) {
            arg.open(rcb);
        }
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        ArrayValueImpl array;
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        if (this.theIsConditional) {
            boolean more = this.theArgs[0].next(rcb);
            if (!more) {
                state.done();
                return false;
            }
            FieldValueImpl val = rcb.getRegVal(this.theArgs[0].getResultReg());
            if (val.isTuple()) {
                val = ((TupleValue)val).toRecord();
            }
            if (!(more = this.theArgs[0].next(rcb))) {
                rcb.setRegVal(this.theResultReg, val);
                state.done();
                return true;
            }
            array = this.theDef.createArray();
            try {
                if (!val.isNull()) {
                    array.add(val);
                }
                if ((val = rcb.getRegVal(this.theArgs[0].getResultReg())).isTuple()) {
                    val = ((TupleValue)val).toRecord();
                }
                if (!val.isNull()) {
                    array.add(val);
                }
            }
            catch (IllegalArgumentException e) {
                this.handleIAE(rcb, val, e);
            }
        } else {
            array = this.theDef.createArray();
        }
        for (int currArg = 0; currArg < this.theArgs.length; ++currArg) {
            boolean more;
            while (more = this.theArgs[currArg].next(rcb)) {
                FieldValueImpl val = rcb.getRegVal(this.theArgs[currArg].getResultReg());
                if (val.isNull()) continue;
                try {
                    if (val.isTuple()) {
                        array.add(((TupleValue)val).toRecord());
                        continue;
                    }
                    array.add(val);
                }
                catch (IllegalArgumentException e) {
                    this.handleIAE(rcb, val, e);
                }
            }
        }
        rcb.setRegVal(this.theResultReg, array);
        state.done();
        return true;
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        for (PlanIter arg : this.theArgs) {
            arg.reset(rcb);
        }
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        for (PlanIter arg : this.theArgs) {
            arg.close(rcb);
        }
        state.close();
    }

    private void handleIAE(RuntimeControlBlock rcb, FieldValueImpl val, IllegalArgumentException e) {
        if (rcb.getTraceLevel() >= 1) {
            rcb.trace("Query Plan:\n" + rcb.getRootIter().display() + "\nValue:\n" + val);
        }
        throw new QueryException(e, this.theLocation);
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        if (this.theIsConditional) {
            formatter.indent(sb);
            sb.append("conditional");
            sb.append(",\n");
        }
        formatter.indent(sb);
        sb.append("Type:\n");
        formatter.indent(sb);
        this.theDef.display(sb, formatter);
        sb.append("\n\n");
        for (int i = 0; i < this.theArgs.length; ++i) {
            this.theArgs[i].display(sb, formatter);
            if (i >= this.theArgs.length - 1) continue;
            sb.append(",\n");
        }
    }
}

