/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.coordination;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.CommunicationException;
import org.eclipse.persistence.exceptions.RemoteCommandManagerException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.SecurableObjectHolder;
import org.eclipse.persistence.internal.sessions.coordination.ConnectToHostCommand;
import org.eclipse.persistence.internal.sessions.coordination.RemoteConnection;
import org.eclipse.persistence.sessions.coordination.DiscoveryManager;
import org.eclipse.persistence.sessions.coordination.RemoteCommandManager;
import org.eclipse.persistence.sessions.coordination.ServiceId;

public abstract class TransportManager {
    protected RemoteConnection localConnection;
    protected RemoteCommandManager rcm;
    protected int namingServiceType;
    protected Hashtable localContextProperties;
    protected Hashtable remoteContextProperties;
    protected boolean shouldRemoveConnectionOnError;
    protected Hashtable<String, RemoteConnection> connectionsToExternalServices;
    protected SecurableObjectHolder securableObjectHolder;
    public static final boolean DEFAULT_REMOVE_CONNECTION_ON_ERROR_MODE = true;
    public static final int JNDI_NAMING_SERVICE = 0;
    public static final int REGISTRY_NAMING_SERVICE = 1;
    public static final String DEFAULT_URL_PROTOCOL = "rmi";
    public static final String DEFAULT_IIOP_URL_PROTOCOL = "corbaname";
    public static final String DEFAULT_URL_PORT = "23791";
    public static final String DEFAULT_IIOP_URL_PORT = "5555#";
    public static final int DEFAULT_NAMING_SERVICE = 0;
    public static final String DEFAULT_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    public static final String DEFAULT_DEDICATED_CONNECTION_KEY = "dedicated.connection";
    public static final String DEFAULT_DEDICATED_CONNECTION_VALUE = "true";
    public static final String DEFAULT_USER_NAME = "admin";

    public abstract RemoteConnection createConnection(ServiceId var1);

    public void createConnections() {
    }

    public void connectBackToRemote(RemoteConnection connection) throws Exception {
        ConnectToHostCommand command = new ConnectToHostCommand();
        command.setServiceId(this.rcm.getServiceId());
        connection.executeCommand(command);
    }

    public RemoteConnection getConnectionToLocalHost() {
        return this.localConnection;
    }

    public abstract void createLocalConnection();

    public int getNamingServiceType() {
        return this.namingServiceType;
    }

    public void setNamingServiceType(int serviceType) {
        this.namingServiceType = serviceType;
    }

    public String getUserName() {
        return (String)this.getRemoteContextProperties().get("java.naming.security.principal");
    }

    public void setUserName(String userName) {
        this.getRemoteContextProperties().put("java.naming.security.principal", userName);
    }

    public String getPassword() {
        return this.decrypt(this.getEncryptedPassword());
    }

    public String getEncryptedPassword() {
        return (String)this.getRemoteContextProperties().get("java.naming.security.credentials");
    }

    public void setPassword(String password) {
        if (password != null) {
            this.getRemoteContextProperties().put("java.naming.security.credentials", this.encrypt(password));
        }
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.getRemoteContextProperties().put("java.naming.security.credentials", encryptedPassword);
    }

    public String getInitialContextFactoryName() {
        return (String)this.getRemoteContextProperties().get("java.naming.factory.initial");
    }

    public void setInitialContextFactoryName(String contextFactoryName) {
        this.getRemoteContextProperties().put("java.naming.factory.initial", contextFactoryName);
    }

    public Context getContext(Hashtable contextProperties) {
        try {
            return new InitialContext(contextProperties);
        }
        catch (NamingException exception) {
            RemoteCommandManagerException rcmException = RemoteCommandManagerException.errorObtainingContext(exception);
            this.rcm.handleException(RemoteCommandManagerException.errorObtainingContext(exception));
            throw rcmException;
        }
    }

    public Hashtable getRemoteContextProperties() {
        return this.remoteContextProperties;
    }

    public void setRemoteContextProperties(Hashtable properties) {
        this.remoteContextProperties = properties;
    }

    public Hashtable getLocalContextProperties() {
        if (this.localContextProperties == null) {
            this.localContextProperties = new Hashtable();
        }
        return this.localContextProperties;
    }

    public void setLocalContextProperties(Hashtable properties) {
        this.localContextProperties = properties;
    }

    public RemoteCommandManager getRemoteCommandManager() {
        return this.rcm;
    }

    public void setRemoteCommandManager(RemoteCommandManager rcm) {
        this.rcm = rcm;
    }

    public void addConnectionToExternalService(RemoteConnection connection) {
        block5: {
            if (connection == null) {
                return;
            }
            try {
                this.connectBackToRemote(connection);
                this.connectionsToExternalServices.put(connection.getServiceId().getId(), connection);
                Object[] args = new Object[]{connection.getServiceId()};
                this.rcm.logDebug("received_connection_from", args);
            }
            catch (Exception exception) {
                try {
                    this.rcm.handleException(CommunicationException.errorSendingConnectionService(connection.toString(), exception));
                }
                catch (RuntimeException reThrownException) {
                    Object[] args = new Object[]{connection.getServiceId(), reThrownException};
                    this.rcm.logWarning("problem_adding_connection", args);
                    if (this.shouldRemoveConnectionOnError) break block5;
                    throw reThrownException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionToExternalService(RemoteConnection connection) {
        TransportManager transportManager = this;
        synchronized (transportManager) {
            this.connectionsToExternalServices.remove(connection.getServiceId().getId());
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllConnectionsToExternalServices() {
        TransportManager transportManager = this;
        synchronized (transportManager) {
            Enumeration<RemoteConnection> connections = this.connectionsToExternalServices.elements();
            this.connectionsToExternalServices = new Hashtable(3);
            while (connections.hasMoreElements()) {
                connections.nextElement().close();
            }
        }
    }

    public Map<String, RemoteConnection> getConnectionsToExternalServices() {
        return this.connectionsToExternalServices;
    }

    public Map<String, RemoteConnection> getConnectionsToExternalServicesForCommandPropagation() {
        return (Map)this.connectionsToExternalServices.clone();
    }

    public void setShouldRemoveConnectionOnError(boolean shouldRemoveConnectionOnError) {
        this.shouldRemoveConnectionOnError = shouldRemoveConnectionOnError;
    }

    public boolean shouldRemoveConnectionOnError() {
        return this.shouldRemoveConnectionOnError;
    }

    public void setEncryptionClassName(String encryptionClassName) {
        SecurableObjectHolder oldHolder = this.securableObjectHolder;
        this.securableObjectHolder = new SecurableObjectHolder();
        this.securableObjectHolder.setEncryptionClassName(encryptionClassName);
        if (this.hasPassword()) {
            this.setPassword(oldHolder.getSecurableObject().decryptPassword(this.getEncryptedPassword()));
        }
    }

    protected boolean hasPassword() {
        return this.getRemoteContextProperties().containsKey("java.naming.security.credentials") && this.getRemoteContextProperties().get("java.naming.security.credentials") != null;
    }

    public void initialize() {
        this.shouldRemoveConnectionOnError = true;
        this.connectionsToExternalServices = new Hashtable(2);
        this.remoteContextProperties = new Hashtable();
        this.remoteContextProperties.put(DEFAULT_DEDICATED_CONNECTION_KEY, DEFAULT_DEDICATED_CONNECTION_VALUE);
        this.securableObjectHolder = new SecurableObjectHolder();
    }

    protected String encrypt(String pwd) {
        return this.securableObjectHolder.getSecurableObject().encryptPassword(pwd);
    }

    protected String decrypt(String encryptedPwd) {
        return this.securableObjectHolder.getSecurableObject().decryptPassword(encryptedPwd);
    }

    public Context getRemoteHostContext(String remoteHostURL) {
        Hashtable remoteProperties = (Hashtable)this.getRemoteContextProperties().clone();
        if (remoteHostURL != null) {
            remoteProperties.put("java.naming.provider.url", remoteHostURL);
        }
        Object[] args = new Object[]{remoteProperties};
        this.rcm.logDebug("context_props_for_remote_lookup", args);
        if (this.hasPassword()) {
            remoteProperties.put("java.naming.security.credentials", this.getPassword());
        }
        return this.getContext(remoteProperties);
    }

    public DiscoveryManager createDiscoveryManager() {
        return new DiscoveryManager(this.rcm);
    }

    public void discardConnections() {
        this.removeLocalConnection();
        this.removeAllConnectionsToExternalServices();
    }

    public abstract void removeLocalConnection();

    public void setConfig(String config) {
    }

    public static TransportManager newSunCORBATransportManager(RemoteCommandManager rcm) {
        try {
            return (TransportManager)PrivilegedAccessHelper.invokeConstructor(PrivilegedAccessHelper.getConstructorFor(Class.forName("org.eclipse.persistence.sessions.coordination.corba.sun.SunCORBATransportManager"), new Class[]{RemoteCommandManager.class}, false), new Object[]{rcm});
        }
        catch (ReflectiveOperationException e) {
            throw RemoteCommandManagerException.errorInitCorba("org.eclipse.persistence.sessions.coordination.corba.sun.SunCORBATransportManager", e);
        }
    }
}

