/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.tinybundles.core.intern;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.ops4j.io.StreamUtils;
import org.ops4j.pax.tinybundles.core.BuildStrategy;
import org.ops4j.pax.tinybundles.core.intern.Info;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RawBuilder
implements BuildStrategy {
    private static Logger LOG = LoggerFactory.getLogger(RawBuilder.class);
    private static final String BUILT_BY = "Built-By";
    private static final String ENTRY_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String TOOL = "Tool";
    private static final String CREATED_BY = "Created-By";

    @Override
    public abstract InputStream build(Map<String, URL> var1, Map<String, String> var2);

    protected void build(Map<String, URL> resources, Map<String, String> headers, JarOutputStream jarOut) throws IOException {
        JarEntry entry = new JarEntry(ENTRY_MANIFEST);
        jarOut.putNextEntry(entry);
        this.getManifest(headers.entrySet()).write(jarOut);
        jarOut.closeEntry();
        for (Map.Entry<String, URL> entryset : resources.entrySet()) {
            entry = new JarEntry(entryset.getKey());
            LOG.debug("Copying resource " + entry.getName());
            jarOut.putNextEntry(entry);
            InputStream inp = entryset.getValue().openStream();
            StreamUtils.copyStream((InputStream)inp, (OutputStream)jarOut, (boolean)false);
            inp.close();
        }
    }

    private Manifest getManifest(Set<Map.Entry<String, String>> headers) {
        LOG.debug("Creating manifest from added headers.");
        Manifest man = new Manifest();
        String cre = "pax-tinybundles-" + Info.getPaxTinybundlesVersion();
        man.getMainAttributes().putValue("Manifest-Version", "1.0");
        man.getMainAttributes().putValue(BUILT_BY, System.getProperty("user.name"));
        man.getMainAttributes().putValue(CREATED_BY, cre);
        man.getMainAttributes().putValue(TOOL, cre);
        man.getMainAttributes().putValue("TinybundlesVersion", cre);
        for (Map.Entry<String, String> entry : headers) {
            LOG.debug(entry.getKey() + " = " + entry.getValue());
            man.getMainAttributes().putValue(entry.getKey(), entry.getValue());
        }
        return man;
    }
}

