/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.transparentindirection;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrderLine;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractSalesRep;
import org.eclipse.persistence.testing.tests.transparentindirection.TestHashtable;

public abstract class AbstractOrder
implements Serializable {
    public int id;
    public String customerName;
    public Stack contacts2;
    public TestHashtable salesReps2;
    public ValueHolderInterface total;
    public int total2;

    public AbstractOrder() {
        this.initialize();
    }

    public AbstractOrder(String customerName) {
        this();
        this.initialize(customerName);
    }

    public abstract void addContact(String var1);

    public void addContact2(String contact) {
        this.contacts2.addElement(contact);
    }

    public abstract void addLine(AbstractOrderLine var1);

    public abstract void addSalesRep(AbstractSalesRep var1);

    public void addSalesRep2(AbstractSalesRep salesRep) {
        this.salesReps2.put(salesRep.getKey(), salesRep);
        salesRep.addOrder2(this);
    }

    public abstract boolean containsContact(String var1);

    public boolean containsContact2(String contactName) {
        return this.contacts2.contains(contactName);
    }

    public abstract boolean containsLine(AbstractOrderLine var1);

    public abstract boolean containsSalesRep(AbstractSalesRep var1);

    public boolean containsSalesRep2(AbstractSalesRep salesRep) {
        return this.salesReps2.contains(salesRep);
    }

    public Vector getAttributeVector(Enumeration stream) {
        Vector result = new Vector();
        while (stream.hasMoreElements()) {
            result.addElement(stream.nextElement());
        }
        return result;
    }

    public abstract Object getContactContainer();

    public Object getContactContainer2() {
        return this.contacts2;
    }

    public abstract Enumeration getContactStream();

    public Enumeration getContactStream2() {
        return this.contacts2.elements();
    }

    public Vector getContactVector() {
        return this.getAttributeVector(this.getContactStream());
    }

    public Vector getContactVector2() {
        return this.getAttributeVector(this.getContactStream2());
    }

    public abstract Object getLineContainer();

    public abstract void clearLines();

    public abstract Enumeration getLineStream();

    public Vector getLineVector() {
        return this.getAttributeVector(this.getLineStream());
    }

    public abstract int getNumberOfContacts();

    public int getNumberOfContacts2() {
        return this.contacts2.size();
    }

    public abstract int getNumberOfLines();

    public abstract int getNumberOfSalesReps();

    public int getNumberOfSalesReps2() {
        return this.salesReps2.size();
    }

    public abstract Object getSalesRepContainer();

    public Object getSalesRepContainer2() {
        return this.salesReps2;
    }

    public abstract Enumeration getSalesRepStream();

    public Enumeration getSalesRepStream2() {
        return this.salesReps2.elements();
    }

    public Vector getSalesRepVector() {
        return this.getAttributeVector(this.getSalesRepStream());
    }

    public Vector getSalesRepVector2() {
        return this.getAttributeVector(this.getSalesRepStream2());
    }

    public int getTotal() {
        return (Integer)this.total.getValue();
    }

    public int getTotalFromRow(Record row, Session session) {
        int tens = ((Number)row.get((Object)"TOTT")).intValue();
        int ones = ((Number)row.get((Object)"TOTO")).intValue();
        return tens * 10 + ones;
    }

    public int getTotalFromRow2(Record row, Session session) {
        int tens = ((Number)row.get((Object)"TOTT2")).intValue();
        int ones = ((Number)row.get((Object)"TOTO2")).intValue();
        return tens * 10 + ones;
    }

    public int getTotalOnes() {
        return this.getTotal() - this.getTotal() / 10 * 10;
    }

    public int getTotalOnes2() {
        return this.total2 - this.total2 / 10 * 10;
    }

    public int getTotalTens() {
        return this.getTotal() / 10;
    }

    public int getTotalTens2() {
        return this.total2 / 10;
    }

    protected void initialize() {
        this.contacts2 = new Stack();
        this.salesReps2 = new TestHashtable();
        this.total = new ValueHolder((Object)1);
        this.total2 = 0;
    }

    protected void initialize(String customerName) {
        this.customerName = customerName;
    }

    public abstract void removeContact(String var1);

    public void removeContact2(String contact) {
        this.contacts2.removeElement(contact);
    }

    public abstract void removeLine(AbstractOrderLine var1);

    public abstract void removeSalesRep(AbstractSalesRep var1);

    public void removeSalesRep2(AbstractSalesRep salesRep) {
        this.salesReps2.remove(salesRep.getKey());
        salesRep.removeOrder2(this);
    }

    public void setTotal(int total) {
        this.total.setValue((Object)total);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append("Order(");
        buffer.append(this.id);
        buffer.append(": ");
        buffer.append(this.customerName);
        buffer.append(")");
        Object container = this.getLineContainer();
        if (container == null) {
            return buffer.toString();
        }
        buffer.append(System.getProperty("line.separator"));
        if (container instanceof IndirectContainer && !((IndirectContainer)container).isInstantiated()) {
            buffer.append("\t");
            buffer.append("uninstantiated order lines...");
        } else {
            Enumeration stream = this.getLineStream();
            while (stream.hasMoreElements()) {
                buffer.append("\t");
                buffer.append(stream.nextElement());
                buffer.append(System.getProperty("line.separator"));
            }
        }
        return buffer.toString();
    }
}

