/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.logging.FileHandler;
import java.util.logging.Logger;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.eclipse.persistence.sessions.factories.XMLSessionConfigLoader;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class SessionsXMLSchemaJavaLogTest
extends AutoVerifyTestCase {
    DatabaseSession employeeSession;
    protected Exception generationException = null;
    protected Exception fileReadException = null;
    protected String testString = "EmployeeSession login successful";
    protected String fileName = "java.log";

    public SessionsXMLSchemaJavaLogTest() {
        this.setDescription("Test loading of a session xml with java logging against the XML Schema");
    }

    public void reset() {
        if (this.employeeSession != null && this.employeeSession.isConnected()) {
            this.employeeSession.logout();
            SessionManager.getManager().getSessions().remove(this.employeeSession);
            this.employeeSession = null;
        }
        File file = new File(this.fileName);
        file.delete();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        try {
            XMLSessionConfigLoader loader = new XMLSessionConfigLoader("org/eclipse/persistence/testing/models/sessionsxml/XMLSchemaJavaLog.xml");
            this.employeeSession = (DatabaseSession)SessionManager.getManager().getSession(loader, "EmployeeSession", ((Object)((Object)this)).getClass().getClassLoader(), false, true);
            this.employeeSession.setLogLevel(3);
            Logger.getLogger("org.eclipse.persistence").addHandler(new FileHandler(this.fileName));
            this.employeeSession.login();
        }
        catch (Exception e) {
            this.generationException = e;
        }
    }

    protected void verify() {
        if (this.generationException != null) {
            throw new TestErrorException("Exception thrown during session configuration: " + this.generationException.toString());
        }
        if (!this.findStringInFile(this.testString, this.fileName)) {
            String exceptionString = "String: " + this.testString + " not found in " + this.fileName;
            if (this.fileReadException != null) {
                exceptionString = exceptionString + " Exception thrown while reading file. - " + this.fileReadException.toString();
            }
            throw new TestErrorException(exceptionString);
        }
    }

    public boolean findStringInFile(String string, String fileName) {
        try {
            FileReader reader = new FileReader(fileName);
            LineNumberReader lnr = new LineNumberReader(reader);
            String line = lnr.readLine();
            while (line != null) {
                if (line.indexOf(string) > -1) {
                    return true;
                }
                line = lnr.readLine();
            }
        }
        catch (Exception exception) {
            this.fileReadException = exception;
        }
        return false;
    }
}

