/*
 * Copyright (c) 1998, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation from Oracle TopLink
package org.eclipse.persistence.testing.tests.directmap;

import java.util.Vector;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.sessions.SessionEventAdapter;
import org.eclipse.persistence.sessions.SessionEvent;
import org.eclipse.persistence.testing.models.directmap.DirectMapMappings;

/**
 * BUG# 3147183
 */
public class DirectMapMappingBatchReadTest extends AutoVerifyTestCase {
    DirectMapMappings queryResult;
    SessionEventAdapter sessionListener;
    boolean isPostExecutedQuery;

    public DirectMapMappingBatchReadTest() {
        setDescription("Tests that objects direct map mapping are batch read properly.");
    }

    @Override
    public void reset() {
        getSession().getIdentityMapAccessor().initializeIdentityMaps();
        rollbackTransaction();
        getSession().getEventManager().removeListener(sessionListener);
    }

    @Override
    public void setup() throws Exception {
        getSession().getIdentityMapAccessor().initializeIdentityMaps();
        beginTransaction();

        sessionListener = new SessionEventAdapter() {
                    @Override
                    public void postExecuteQuery(SessionEvent event) {
                        isPostExecutedQuery = true;
                    }
                };
        getSession().getEventManager().addListener(sessionListener);

        // Create a directmapmapping with a few items in it
        UnitOfWork uow = getSession().acquireUnitOfWork();
        DirectMapMappings maps1 = (DirectMapMappings)uow.registerObject(new DirectMapMappings());
        maps1.directMap.put(Integer.valueOf(1), "guy");
        maps1.directMap.put(Integer.valueOf(2), "axemen");

        DirectMapMappings maps2 = (DirectMapMappings)uow.registerObject(new DirectMapMappings());
        maps2.directMap.put(Integer.valueOf(1), "steve");
        maps2.directMap.put(Integer.valueOf(2), "superman");

        uow.commit();
    }

    @Override
    public void verify() throws Exception {
        getSession().getIdentityMapAccessor().initializeIdentityMaps();

        Vector maps = getSession().readAllObjects(DirectMapMappings.class);

        // this should trigger the batch read for all direct map mappings
        Object batchRead = ((DirectMapMappings)maps.elementAt(0)).directMapForBatchRead;

        isPostExecutedQuery = false;
        // access second element should not execute a query since it should have batch read
        batchRead = ((DirectMapMappings)maps.elementAt(1)).directMapForBatchRead;

        if (isPostExecutedQuery) {
            throw new TestErrorException("Batch read does not work with direct map mapping");
        }
    }
}
