/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.nosql.adapters.sdk;

import jakarta.resource.cci.InteractionSpec;
import jakarta.resource.cci.MappedRecord;
import jakarta.resource.cci.Record;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.nosql.driver.Consistency;
import oracle.nosql.driver.Durability;
import oracle.nosql.driver.Version;
import oracle.nosql.driver.values.ArrayValue;
import oracle.nosql.driver.values.BinaryValue;
import oracle.nosql.driver.values.BooleanValue;
import oracle.nosql.driver.values.DoubleValue;
import oracle.nosql.driver.values.FieldValue;
import oracle.nosql.driver.values.IntegerValue;
import oracle.nosql.driver.values.LongValue;
import oracle.nosql.driver.values.MapValue;
import oracle.nosql.driver.values.NumberValue;
import oracle.nosql.driver.values.StringValue;
import oracle.nosql.driver.values.TimestampValue;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.eis.EISAccessor;
import org.eclipse.persistence.eis.EISDOMRecord;
import org.eclipse.persistence.eis.EISDescriptor;
import org.eclipse.persistence.eis.EISException;
import org.eclipse.persistence.eis.EISMappedRecord;
import org.eclipse.persistence.eis.EISPlatform;
import org.eclipse.persistence.eis.interactions.EISInteraction;
import org.eclipse.persistence.eis.interactions.MappedInteraction;
import org.eclipse.persistence.eis.interactions.XMLInteraction;
import org.eclipse.persistence.eis.mappings.EISCompositeCollectionMapping;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLInteractionSpec;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLOperation;
import org.eclipse.persistence.internal.nosql.adapters.sdk.OracleNoSQLRecord;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.UUIDSequence;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.factories.SessionManager;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OracleNoSQLPlatform
extends EISPlatform {
    public static String OPERATION = "nosql.operation";
    public static String CONSISTENCY = "nosql.consistency";
    public static String DURABILITY = "nosql.durability";
    public static String TIMEOUT = "nosql.timeout";
    public static String VERSION = "nosql.version";
    public static String QUERY = "nosql_query";
    public static String QUERY_ARGUMENTS = "arguments";
    public static String QUERY_ARGUMENT_TYPE_SUFFIX = "_type";
    public static String QUERY_ARGUMENT_VALUE_SUFFIX = "_value";

    public OracleNoSQLPlatform() {
        this.setShouldConvertDataToStrings(true);
        this.setIsMappedRecordSupported(true);
        this.setIsIndexedRecordSupported(false);
        this.setIsDOMRecordSupported(true);
        this.setSupportsLocalTransactions(true);
    }

    public InteractionSpec buildInteractionSpec(EISInteraction interaction) {
        InteractionSpec spec = interaction.getInteractionSpec();
        if (spec == null) {
            ClassDescriptor descriptor;
            OracleNoSQLInteractionSpec noSqlSpec = new OracleNoSQLInteractionSpec(interaction);
            Object operation = interaction.getProperty(OPERATION);
            if (operation == null) {
                throw EISException.operationPropertyIsNotSet();
            }
            if (operation instanceof String) {
                operation = OracleNoSQLOperation.valueOf((String)operation);
            }
            noSqlSpec.setOperation((OracleNoSQLOperation)((Object)operation));
            String tableName = interaction.getQuery().getDescriptor().getTableName();
            if (tableName == null) {
                throw EISException.tableNameIsNotSet();
            }
            noSqlSpec.setTableName(tableName);
            Object consistency = interaction.getProperty(CONSISTENCY);
            if (consistency == null) {
                consistency = interaction.getQuery().getSession().getProperty(CONSISTENCY);
            }
            if (consistency instanceof Consistency) {
                noSqlSpec.setConsistency((Consistency)consistency);
            } else if (consistency instanceof String) {
                if ("ABSOLUTE".equals(consistency)) {
                    noSqlSpec.setConsistency(Consistency.ABSOLUTE);
                } else if ("EVENTUAL".equals(consistency)) {
                    noSqlSpec.setConsistency(Consistency.EVENTUAL);
                } else {
                    throw EISException.invalidConsistencyPropertyValue((String)((String)consistency));
                }
            }
            Object durability = interaction.getProperty(DURABILITY);
            if (durability == null) {
                durability = interaction.getQuery().getSession().getProperty(DURABILITY);
            }
            if (durability instanceof Durability) {
                noSqlSpec.setDurability((Durability)durability);
            } else if (durability instanceof String) {
                if ("COMMIT_NO_SYNC".equals(durability)) {
                    noSqlSpec.setDurability(Durability.COMMIT_NO_SYNC);
                } else if ("COMMIT_SYNC".equals(durability)) {
                    noSqlSpec.setDurability(Durability.COMMIT_SYNC);
                } else if ("COMMIT_WRITE_NO_SYNC".equals(durability)) {
                    noSqlSpec.setDurability(Durability.COMMIT_WRITE_NO_SYNC);
                } else {
                    throw EISException.invalidDurabilityPropertyValue((String)((String)durability));
                }
            }
            Object timeout = interaction.getProperty(TIMEOUT);
            if (timeout == null) {
                timeout = interaction.getQuery().getSession().getProperty(TIMEOUT);
            }
            if (timeout instanceof Number) {
                noSqlSpec.setTimeout(((Number)timeout).intValue());
            } else if (timeout instanceof String) {
                noSqlSpec.setTimeout(Integer.parseInt((String)timeout));
            } else if (interaction.getQuery().getQueryTimeout() > 0) {
                noSqlSpec.setTimeout(interaction.getQuery().getQueryTimeout());
            }
            Object version = interaction.getProperty(VERSION);
            if (version == null) {
                version = interaction.getQuery().getSession().getProperty(VERSION);
            }
            if (version == null && interaction.getQuery().getDescriptor() != null && (descriptor = interaction.getQuery().getDescriptor()).usesOptimisticLocking() && descriptor.getOptimisticLockingPolicy() instanceof SelectedFieldsLockingPolicy) {
                DatabaseField field = (DatabaseField)((SelectedFieldsLockingPolicy)descriptor.getOptimisticLockingPolicy()).getLockFields().get(0);
                if (interaction.getInputRow() != null) {
                    version = interaction.getInputRow().get(field);
                }
            }
            if (version instanceof Version) {
                noSqlSpec.setVersion((Version)version);
            } else if (version instanceof byte[]) {
                noSqlSpec.setVersion(Version.createVersion((byte[])((byte[])version)));
            }
            if (interaction.getQuery().getDescriptor() != null) {
                noSqlSpec.setDescriptor(interaction.getQuery().getDescriptor());
            }
            spec = noSqlSpec;
        }
        return spec;
    }

    public AbstractRecord buildRow(Record record, EISInteraction interaction, EISAccessor accessor) {
        OracleNoSQLRecord output;
        if (record == null) {
            return null;
        }
        OracleNoSQLRecord result = output = (OracleNoSQLRecord)record;
        if (this.getRecordConverter() != null) {
            result = this.getRecordConverter().converterFromAdapterRecord((Record)output);
        }
        return interaction.buildRow((Record)result, accessor);
    }

    public Vector<AbstractRecord> buildRows(Record record, EISInteraction interaction, EISAccessor accessor) {
        if (record == null) {
            return new Vector<AbstractRecord>(0);
        }
        OracleNoSQLRecord output = (OracleNoSQLRecord)record;
        if (interaction.getQuery().getDescriptor() != null) {
            Vector<AbstractRecord> rows = new Vector<AbstractRecord>();
            for (Object value : output.values()) {
                rows.add(this.buildRow((Record)value, interaction, accessor));
            }
            return rows;
        }
        return interaction.buildRows(record, accessor);
    }

    public Record createInputRecord(EISInteraction interaction, EISAccessor accessor) {
        if (interaction instanceof XMLInteraction) {
            return super.createInputRecord(interaction, accessor);
        }
        if (interaction instanceof MappedInteraction) {
            MappedRecord input = (MappedRecord)interaction.createInputRecord(accessor);
            ClassDescriptor descriptor = interaction.getQuery().getDescriptor();
            if (descriptor == null) {
                if (this.getRecordConverter() != null) {
                    return this.getRecordConverter().converterToAdapterRecord((Record)input);
                }
                return input;
            }
            Object key = this.createMajorKey(descriptor, (AbstractRecord)new EISMappedRecord((Map)input, accessor), interaction, accessor);
            OracleNoSQLRecord record = new OracleNoSQLRecord();
            record.put(key, input);
            if (this.getRecordConverter() != null) {
                return this.getRecordConverter().converterToAdapterRecord((Record)record);
            }
            return record;
        }
        return super.createInputRecord(interaction, accessor);
    }

    public void setDOMInRecord(Element dom, Record record, EISInteraction interaction, EISAccessor accessor) {
        OracleNoSQLRecord noSqlRecord = (OracleNoSQLRecord)record;
        DOMRecord domRecord = new DOMRecord(dom);
        domRecord.setSession(interaction.getQuery().getSession());
        ClassDescriptor descriptor = interaction.getQuery().getDescriptor();
        if (descriptor == null) {
            throw EISException.xmlInteractionIsValidOnly((String)interaction.toString());
        }
        Object key = this.createMajorKey(descriptor, (AbstractRecord)domRecord, interaction, accessor);
        noSqlRecord.put(key, domRecord.transformToXML().getBytes());
    }

    protected Object createMajorKey(ClassDescriptor descriptor, AbstractRecord record, EISInteraction interaction, EISAccessor accessor) {
        Object id = descriptor.getObjectBuilder().extractPrimaryKeyFromRow(record, interaction.getQuery().getSession());
        ArrayList<String> key = new ArrayList<String>(descriptor.getPrimaryKeyFields().size() + 1);
        if (((EISDescriptor)descriptor).getDataTypeName().length() > 0) {
            key.add(((EISDescriptor)descriptor).getDataTypeName());
        }
        if (id != null) {
            if (id instanceof CacheId) {
                Object[] idValues;
                for (Object idValue : idValues = ((CacheId)id).getPrimaryKey()) {
                    String idString = (String)accessor.getDatasourcePlatform().getConversionManager().convertObject(idValue, String.class);
                    key.add(idString);
                }
            } else {
                String idString = (String)accessor.getDatasourcePlatform().getConversionManager().convertObject(id, String.class);
                key.add(idString);
            }
        }
        return key;
    }

    public AbstractRecord createDatabaseRowFromDOMRecord(Record record, EISInteraction call, EISAccessor accessor) {
        if (record == null) {
            return null;
        }
        EISDOMRecord domRecord = null;
        OracleNoSQLRecord noSqlRecord = (OracleNoSQLRecord)record;
        if (noSqlRecord.size() == 0) {
            return null;
        }
        HashMap<String, DatabaseMapping> mappings = new HashMap<String, DatabaseMapping>();
        ClassDescriptor descriptor = call.getQuery().getDescriptor();
        String sessionName = descriptor.getSessionName();
        Object session = null;
        session = sessionName != null && !sessionName.isEmpty() ? SessionManager.getManager().getSession(sessionName) : SessionManager.getManager().getDefaultSession();
        for (DatabaseMapping databaseMapping : descriptor.getMappings()) {
            for (DatabaseField field : databaseMapping.getFields()) {
                mappings.put(field.getName().replaceAll("/text\\(\\)", "").toLowerCase(), databaseMapping);
            }
        }
        domRecord = new EISDOMRecord();
        domRecord.setDOM(domRecord.createNewDocument(((XMLInteraction)call).getOutputRootElementName()));
        domRecord.setSession((AbstractSession)session);
        for (Map.Entry entry : noSqlRecord.entrySet()) {
            DatabaseMapping mapping = (DatabaseMapping)mappings.get(((String)entry.getKey()).toLowerCase());
            if (mapping == null) continue;
            if (entry.getValue() instanceof Map) {
                Map subRecord = (Map)entry.getValue();
                domRecord.put(mapping.getField(), (Object)"");
                EISDOMRecord domSubRecord = (EISDOMRecord)domRecord.buildNestedRow((Element)domRecord.getDOM().getLastChild());
                domSubRecord.setSession((AbstractSession)session);
                HashMap<String, DatabaseMapping> subMappings = new HashMap<String, DatabaseMapping>();
                for (DatabaseMapping databaseMapping : mapping.getReferenceDescriptor().getMappings()) {
                    subMappings.put(databaseMapping.getField().getName().replaceAll("\\@", "").replaceAll("/text\\(\\)", "").toLowerCase(), databaseMapping);
                }
                for (Map.Entry entry2 : subRecord.entrySet()) {
                    domSubRecord.put(((DatabaseMapping)subMappings.get(((String)entry2.getKey()).toLowerCase())).getField(), entry2.getValue());
                }
                continue;
            }
            if (entry.getValue() != null && (entry.getValue().getClass().isArray() || entry.getValue() instanceof List)) {
                HashMap<String, DatabaseMapping> subMappings = new HashMap<String, DatabaseMapping>();
                if (mapping.getReferenceDescriptor() == null) {
                    subMappings.put(mapping.getField().getName().replaceAll("\\@", "").replaceAll("/text\\(\\)", "").toLowerCase(), mapping);
                } else {
                    for (DatabaseMapping subMapping : mapping.getReferenceDescriptor().getMappings()) {
                        subMappings.put(subMapping.getField().getName().replaceAll("\\@", "").replaceAll("/text\\(\\)", "").toLowerCase(), subMapping);
                    }
                }
                if (mapping instanceof EISCompositeCollectionMapping) {
                    domRecord.put(mapping.getField(), (Object)"");
                }
                Object[] entryValue = entry.getValue() instanceof List ? ((List)entry.getValue()).toArray() : (Object[])entry.getValue();
                for (int i = 0; i < entryValue.length; ++i) {
                    Object arrayItem = entryValue[i];
                    if (i > 0) {
                        Element element = (Element)domRecord.getDOM().getLastChild();
                        Element newLastChild = (Element)element.cloneNode(false);
                        domRecord.getDOM().appendChild(newLastChild);
                    }
                    if (arrayItem instanceof Map) {
                        EISDOMRecord eISDOMRecord = (EISDOMRecord)domRecord.buildNestedRow((Element)domRecord.getDOM().getLastChild());
                        eISDOMRecord.setSession((AbstractSession)session);
                        for (Map.Entry subEntry : ((Map)arrayItem).entrySet()) {
                            if (subEntry.getValue() == null) continue;
                            eISDOMRecord.put(((DatabaseMapping)subMappings.get(((String)subEntry.getKey()).toLowerCase())).getField(), subEntry.getValue());
                        }
                        continue;
                    }
                    domRecord.add(((DatabaseMapping)subMappings.get(entry.getKey())).getField(), arrayItem);
                }
                continue;
            }
            if (entry.getValue() == null) continue;
            domRecord.put(mapping.getField(), entry.getValue());
        }
        return domRecord;
    }

    public void initializeDefaultQueries(DescriptorQueryManager queryManager, AbstractSession session) {
        XMLInteraction call;
        boolean isXML = ((EISDescriptor)queryManager.getDescriptor()).isXMLFormat();
        if (!queryManager.hasInsertQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.PUT_IF_ABSENT);
            queryManager.setInsertCall((Call)call);
        }
        if (!queryManager.hasUpdateQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.PUT_IF_PRESENT);
            queryManager.setUpdateCall((Call)call);
        }
        if (!queryManager.hasReadObjectQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.GET);
            for (DatabaseField field : queryManager.getDescriptor().getPrimaryKeyFields()) {
                call.addArgument(field.getName());
            }
            queryManager.setReadObjectCall((Call)call);
        }
        if (!queryManager.hasReadAllQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.ITERATOR);
            queryManager.setReadAllCall((Call)call);
        }
        if (!queryManager.hasDeleteQuery()) {
            call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.DELETE);
            for (DatabaseField field : queryManager.getDescriptor().getPrimaryKeyFields()) {
                call.addArgument(field.getName());
            }
            queryManager.setDeleteCall((Call)call);
        }
    }

    public DatasourceCall buildCallFromStatement(SQLStatement statement, DatabaseQuery query, AbstractSession session) {
        boolean isXML = ((EISDescriptor)query.getDescriptor()).isXMLFormat();
        if (query.isObjectLevelReadQuery()) {
            XMLInteraction call = isXML ? new XMLInteraction() : new MappedInteraction();
            call.setProperty(OPERATION, (Object)OracleNoSQLOperation.ITERATOR_QUERY);
            DatabaseRecord row = new DatabaseRecord();
            DatabaseCall sqlCall = ((SQLSelectStatement)statement).buildCall(session, query);
            Object sqlString = sqlCall.getSQLString();
            StringBuilder sqlVariables = null;
            StringBuilder parameterNames = null;
            sqlString = ((String)sqlString).replaceAll("/text\\(\\)", "");
            List parameters = sqlCall.getParameters();
            for (ParameterExpression parameter : parameters) {
                if (sqlVariables == null && parameterNames == null) {
                    sqlVariables = new StringBuilder("DECLARE");
                    parameterNames = new StringBuilder();
                }
                String parameterName = parameter.getField().getName();
                Object parameterValue = parameter.getValue(statement.getTranslationRow(), session);
                String parameterTypeName = ((Class)parameter.getType()).getName();
                FieldValue fieldValue = OracleNoSQLPlatform.getFieldValue(parameterTypeName, parameterValue.toString(), false);
                parameterNames.append(parameterName + ";");
                sqlVariables.append(" $" + parameterName + " " + fieldValue.getType().name() + ";");
                sqlString = ((String)sqlString).replaceFirst("\\?", "\\$" + parameterName);
                row.put(parameterName + QUERY_ARGUMENT_VALUE_SUFFIX, parameterValue);
                row.put(parameterName + QUERY_ARGUMENT_TYPE_SUFFIX, (Object)parameterTypeName);
            }
            if (parameters.size() > 0) {
                sqlString = sqlVariables + " " + (String)sqlString;
                row.put(QUERY_ARGUMENTS, parameterNames);
            }
            row.put(QUERY, sqlString);
            call.setInputRow((AbstractRecord)row);
            return call;
        }
        throw EISException.queryIsTooComplexForOracleNoSQLDB((String)query.toString());
    }

    public boolean shouldPrepare(DatabaseQuery query) {
        return query.getDatasourceCall() instanceof EISInteraction;
    }

    protected Sequence createPlatformDefaultSequence() {
        return new UUIDSequence();
    }

    public static FieldValue getFieldValue(String typeName, Object value, boolean isLob) {
        BooleanValue fieldValue = null;
        if ("boolean".equals(typeName) || "java.lang.Boolean".equals(typeName)) {
            fieldValue = Boolean.valueOf(value.toString()) != false ? BooleanValue.trueInstance() : BooleanValue.falseInstance();
        } else if ("double".equals(typeName) || "java.lang.Double".equals(typeName)) {
            fieldValue = new DoubleValue(value.toString());
        } else if ("int".equals(typeName) || "java.lang.Integer".equals(typeName)) {
            fieldValue = new IntegerValue(value.toString());
        } else if ("long".equals(typeName) || "java.lang.Long".equals(typeName)) {
            fieldValue = new LongValue(value.toString());
        } else if ("java.lang.String".equals(typeName)) {
            fieldValue = new StringValue(value.toString());
        } else if ("java.sql.Timestamp".equals(typeName)) {
            fieldValue = new TimestampValue(value.toString());
        } else if ("java.math.BigDecimal".equals(typeName)) {
            fieldValue = new NumberValue(value.toString());
        } else if (typeName.contains("byte[]") && isLob) {
            fieldValue = new BinaryValue((byte[])value);
        } else if (typeName.contains("[]") && !isLob) {
            fieldValue = new ArrayValue();
            for (Object item : (Object[])value) {
                ((ArrayValue)fieldValue).add(OracleNoSQLPlatform.getFieldValue(typeName.replace("[]", ""), item, false));
            }
        } else if ("java.util.Map".equals(typeName)) {
            fieldValue = new MapValue();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String valueTypeName = entry.getValue().getClass().getName();
                ((MapValue)fieldValue).put(entry.getKey().toString(), OracleNoSQLPlatform.getFieldValue(valueTypeName, entry.getValue(), false));
            }
        } else {
            fieldValue = new StringValue(value.toString());
        }
        return fieldValue;
    }

    public static boolean isLob(String typeName) {
        return ClassConstants.BLOB.getName().equals(typeName) || ClassConstants.CLOB.getName().equals(typeName);
    }

    public <T> T convertObject(Object sourceObject, Class<T> javaClass) throws ConversionException, DatabaseException {
        if (sourceObject instanceof DOMRecord) {
            sourceObject = ((Node)((DOMRecord)sourceObject).getValues().get(0)).getNodeValue();
        }
        return (T)super.convertObject(sourceObject, javaClass);
    }
}

