/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa22.metadata;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAsmFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.testing.framework.jpa.junit.JUnitTestCase;
import org.eclipse.persistence.testing.tests.jpa22.metadata.Employee;
import org.eclipse.samples.annotations.CycleA;
import org.eclipse.samples.annotations.CycleB;
import org.eclipse.samples.annotations.CycleSelf;
import org.junit.Assert;

public class MetadataASMFactoryTest
extends JUnitTestCase {
    public MetadataASMFactoryTest() {
    }

    public MetadataASMFactoryTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("MetadataASMFactoryTest");
        suite.addTest((Test)new MetadataASMFactoryTest("testMetadataAnnotations"));
        suite.addTest((Test)new MetadataASMFactoryTest("testAnnotationsWithCycle"));
        suite.addTest((Test)new MetadataASMFactoryTest("testAnnotationsWithPrimitiveCycle"));
        return suite;
    }

    public void testMetadataAnnotations() {
        MetadataAsmFactory fact = new MetadataAsmFactory(new MetadataLogger(null), MetadataASMFactoryTest.class.getClassLoader());
        MetadataClass metadataClass = fact.getMetadataClass(Employee.class.getName());
        MetadataAnnotation annotation = metadataClass.getAnnotation("jakarta.persistence.Entity");
        Assert.assertNotNull((Object)annotation);
        Assert.assertTrue((boolean)PersistenceUnitProcessor.isEntity((MetadataClass)metadataClass));
        Assert.assertNotNull((Object)PersistenceUnitProcessor.getEntityAnnotation((MetadataClass)metadataClass));
        annotation = metadataClass.getAnnotation("jakarta.persistence.EntityListeners");
        Assert.assertNotNull((Object)annotation);
    }

    public void testAnnotationsWithCycle() {
        try {
            MetadataAsmFactory fact = new MetadataAsmFactory(new MetadataLogger(null), MetadataASMFactoryTest.class.getClassLoader());
            MetadataClass metadataClass = fact.getMetadataClass(CycleA.class.getName());
            MetadataAnnotation annotation = metadataClass.getAnnotation("org.eclipse.samples.annotations.CycleC");
            metadataClass = fact.getMetadataClass(CycleB.class.getName());
            MetadataAnnotation metadataAnnotation = metadataClass.getAnnotation("org.eclipse.samples.annotations.CycleA");
        }
        catch (StackOverflowError e) {
            MetadataASMFactoryTest.fail((String)"Stack overflow while processing cycle in meta-annotations");
        }
    }

    public void testAnnotationsWithPrimitiveCycle() {
        try {
            MetadataAsmFactory fact = new MetadataAsmFactory(new MetadataLogger(null), MetadataASMFactoryTest.class.getClassLoader());
            MetadataClass metadataClass = fact.getMetadataClass(CycleSelf.class.getName());
            MetadataAnnotation metadataAnnotation = metadataClass.getAnnotation("org.eclipse.samples.annotations.CycleSelf");
        }
        catch (StackOverflowError e) {
            MetadataASMFactoryTest.fail((String)"Stack overflow while processing cycle in meta-annotations");
        }
    }
}

