/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class FieldTest
extends PerformanceComparisonTestCase {
    protected Object variable;

    public FieldTest() {
        this.setName("FieldAccess vs Reflection PerformanceComparisonTest");
        this.setDescription("This test compares the performance for field reflection.");
        this.addSetMethodTest();
        this.addReflectionFieldTest();
        this.addReflectionMethodTest();
        this.addAssignableSetTest();
    }

    public void test() throws Exception {
        this.variable = new String("hello");
    }

    public void addSetMethodTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected Object variable;

            public void test() {
                this.setVariable(new String("hello"));
            }

            public void setVariable(Object value) {
                this.variable = value;
            }
        };
        test.setName("SetMethodTest");
        this.addTest((TestCase)test);
    }

    public void addAssignableSetTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected Object variable;
            public Class<Object> object = Object.class;

            public void test() {
                if (!((Object)((Object)this)).getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
                    throw new Error("Not assignable");
                }
                String hello = new String("hello");
                if (!this.object.isAssignableFrom(hello.getClass())) {
                    throw new Error("Not assignable");
                }
                this.variable = hello;
            }
        };
        test.setName("AssignableSetTest");
        this.addTest((TestCase)test);
    }

    public void addReflectionMethodTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected Object variable;
            public Method method;

            public final void test() {
                if (this.method == null) {
                    Class[] argTypes = new Class[]{Object.class};
                    try {
                        this.method = ((Object)((Object)this)).getClass().getMethod("setVariable", argTypes);
                    }
                    catch (Exception ignore) {
                        throw new Error(ignore.toString());
                    }
                }
                try {
                    Object[] args = new Object[]{new String("hello")};
                    this.method.invoke((Object)this, args);
                }
                catch (Exception ignore) {
                    throw new Error(ignore.toString());
                }
            }

            public void setVariable(Object value) throws Exception {
                this.variable = value;
            }
        };
        test.setName("ReflectionMethodTest");
        this.addTest((TestCase)test);
    }

    public void addReflectionFieldTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){
            protected Object variable;
            public Field field;

            public final void test() {
                if (this.field == null) {
                    try {
                        this.field = ((Object)((Object)this)).getClass().getDeclaredField("variable");
                        this.field.setAccessible(true);
                    }
                    catch (Exception ignore) {
                        throw new Error(ignore.toString());
                    }
                }
                try {
                    this.field.set((Object)this, new String("hello"));
                }
                catch (Exception ignore) {
                    throw new Error(ignore.toString());
                }
            }
        };
        test.setName("ReflectionFieldTest");
        this.addTest((TestCase)test);
    }
}

