/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class ExceptionsRaisedUnitOfWorkTest
extends AutoVerifyTestCase {
    public ExceptionsRaisedUnitOfWorkTest() {
        this.setDescription("This test verifies that illegal operations will raise exceptions in Unit Of Work.");
    }

    protected void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        boolean exceptionCaught = false;
        Employee employee = (Employee)this.getSession().readAllObjects(Employee.class).firstElement();
        UnitOfWork firstUOW = this.getSession().acquireUnitOfWork();
        Vector employees = firstUOW.readAllObjects(Employee.class);
        Employee uowEmployee = (Employee)employees.elementAt(2);
        uowEmployee.setAddress(employee.getAddress());
        try {
            firstUOW.commit();
        }
        catch (QueryException exception) {
            exceptionCaught = true;
        }
        if (!exceptionCaught) {
            throw new TestErrorException("Performed illegal operations in UOW yet no exception was thrown");
        }
    }
}

