/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.KVStore;
import oracle.kv.KVStoreConfig;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;

public class KVStoreInternalFactory {
    public static KVStore getStore(KVStoreConfig config, RequestDispatcher dispatcher, LoginManager loginMgr, Logger logger) throws IllegalArgumentException {
        long readTimeoutMs;
        long requestTimeoutMs = config.getRequestTimeout(TimeUnit.MILLISECONDS);
        if (requestTimeoutMs > (readTimeoutMs = config.getSocketReadTimeout(TimeUnit.MILLISECONDS))) {
            String format = "Invalid KVStoreConfig. Request timeout: %,d ms exceeds socket read timeout: %,d ms";
            throw new IllegalArgumentException(String.format("Invalid KVStoreConfig. Request timeout: %,d ms exceeds socket read timeout: %,d ms", requestTimeoutMs, readTimeoutMs));
        }
        RegistryUtils.setRegistrySocketTimeouts((int)config.getRegistryOpenTimeout(TimeUnit.MILLISECONDS), (int)config.getRegistryReadTimeout(TimeUnit.MILLISECONDS), config.getStoreName());
        String csfName = ClientSocketFactory.factoryName(config.getStoreName(), RepNodeId.getPrefix(), RegistryUtils.InterfaceType.MAIN.interfaceName());
        int openTimeoutMs = (int)config.getSocketOpenTimeout(TimeUnit.MILLISECONDS);
        ClientSocketFactory.configureStoreTimeout(csfName, openTimeoutMs, (int)readTimeoutMs);
        return new KVStoreImpl(logger, dispatcher, config, loginMgr);
    }

    public static KVStore getStore(RepNodeService repNodeService, Logger logger) {
        String storeName = repNodeService.getParams().getGlobalParams().getKVStoreName();
        KVStoreConfig config = new KVStoreConfig(storeName, "unknownhost:0");
        return KVStoreInternalFactory.getStore(config, repNodeService.getRepNode().getRequestDispatcher(), repNodeService.getLoginManager(), logger);
    }
}

