/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class PartialAttributeWithCustomSQLTest
extends TestCase {
    protected Exception caughtException;

    public PartialAttributeWithCustomSQLTest() {
        this.setDescription("Test querying with partial attributes in conjunction with using custom SQL");
    }

    public void test() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Employee.class);
        String tableName = descriptor.getTableName();
        query.setCall((Call)new SQLCall("SELECT * FROM " + tableName));
        query.addPartialAttribute("id");
        query.addPartialAttribute("firstName");
        query.addPartialAttribute("lastName");
        query.addPartialAttribute("gender");
        query.dontMaintainCache();
        try {
            this.getSession().executeQuery((DatabaseQuery)query);
        }
        catch (Exception exception) {
            this.caughtException = exception;
        }
    }

    public void verify() {
        if (this.caughtException != null) {
            String msg = "Caught an unexpected exception while querying with partial attributes and custom SQL";
            throw new TestErrorException("Caught an unexpected exception while querying with partial attributes and custom SQL", (Throwable)this.caughtException);
        }
    }
}

