/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.hadoop.hive.table;

import java.util.ArrayList;
import java.util.List;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.MapDef;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordDef;
import oracle.kv.table.RecordValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public enum TableFieldTypeEnum {
    TABLE_FIELD_STRING{

        public String toString() {
            return FieldDef.Type.STRING.toString();
        }
    }
    ,
    TABLE_FIELD_BOOLEAN{

        public String toString() {
            return FieldDef.Type.BOOLEAN.toString();
        }
    }
    ,
    TABLE_FIELD_INTEGER{

        public String toString() {
            return FieldDef.Type.INTEGER.toString();
        }
    }
    ,
    TABLE_FIELD_LONG{

        public String toString() {
            return FieldDef.Type.LONG.toString();
        }
    }
    ,
    TABLE_FIELD_FLOAT{

        public String toString() {
            return FieldDef.Type.FLOAT.toString();
        }
    }
    ,
    TABLE_FIELD_DOUBLE{

        public String toString() {
            return FieldDef.Type.DOUBLE.toString();
        }
    }
    ,
    TABLE_FIELD_ENUM{

        public String toString() {
            return FieldDef.Type.ENUM.toString();
        }
    }
    ,
    TABLE_FIELD_BINARY{

        public String toString() {
            return FieldDef.Type.BINARY.toString();
        }
    }
    ,
    TABLE_FIELD_FIXED_BINARY{

        public String toString() {
            return FieldDef.Type.FIXED_BINARY.toString();
        }
    }
    ,
    TABLE_FIELD_MAP{

        public String toString() {
            return FieldDef.Type.MAP.toString();
        }
    }
    ,
    TABLE_FIELD_RECORD{

        public String toString() {
            return FieldDef.Type.RECORD.toString();
        }
    }
    ,
    TABLE_FIELD_ARRAY{

        public String toString() {
            return FieldDef.Type.ARRAY.toString();
        }
    }
    ,
    TABLE_FIELD_NULL{

        public String toString() {
            return "NULL kv table field";
        }
    }
    ,
    TABLE_FIELD_UNKNOWN_TYPE{

        public String toString() {
            return "unknown kv table field type";
        }
    };


    public static TableFieldTypeEnum fromKvType(FieldDef.Type kvType) {
        if (kvType == null) {
            return null;
        }
        return TableFieldTypeEnum.stringToEnumValue(kvType.toString());
    }

    public static TableFieldTypeEnum fromHiveType(TypeInfo hiveType) {
        return TableFieldTypeEnum.fromHiveType(hiveType, null);
    }

    public static TableFieldTypeEnum fromHiveType(TypeInfo hiveType, FieldDef.Type kvType) {
        String typeName = hiveType.getTypeName();
        if ("boolean".equals(typeName)) {
            return TABLE_FIELD_BOOLEAN;
        }
        if ("int".equals(typeName)) {
            return TABLE_FIELD_INTEGER;
        }
        if ("bigint".equals(typeName)) {
            return TABLE_FIELD_LONG;
        }
        if ("float".equals(typeName)) {
            return TABLE_FIELD_FLOAT;
        }
        if ("decimal".equals(typeName)) {
            return TABLE_FIELD_FLOAT;
        }
        if ("double".equals(typeName)) {
            return TABLE_FIELD_DOUBLE;
        }
        if ("string".equals(typeName)) {
            return TABLE_FIELD_STRING;
        }
        if ("binary".equals(typeName)) {
            if (TABLE_FIELD_FIXED_BINARY.equals((Object)TableFieldTypeEnum.fromKvType(kvType))) {
                return TABLE_FIELD_FIXED_BINARY;
            }
            return TABLE_FIELD_BINARY;
        }
        if ("tinyint".equals(typeName)) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("smallint".equals(typeName)) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("date".equals(typeName)) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("datetime".equals(typeName)) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("timestamp".equals(typeName)) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        if ("uniontype".equals(typeName)) {
            return TABLE_FIELD_UNKNOWN_TYPE;
        }
        ObjectInspector.Category category = hiveType.getCategory();
        if (ObjectInspector.Category.LIST.equals((Object)category)) {
            return TABLE_FIELD_ARRAY;
        }
        if (ObjectInspector.Category.MAP.equals((Object)category)) {
            if (TABLE_FIELD_ENUM.equals((Object)TableFieldTypeEnum.fromKvType(kvType))) {
                return TABLE_FIELD_ENUM;
            }
            return TABLE_FIELD_MAP;
        }
        if (ObjectInspector.Category.STRUCT.equals((Object)category)) {
            return TABLE_FIELD_RECORD;
        }
        return TABLE_FIELD_UNKNOWN_TYPE;
    }

    public static TableFieldTypeEnum stringToEnumValue(String str) {
        for (TableFieldTypeEnum enumVal : TableFieldTypeEnum.values()) {
            if (!enumVal.toString().equals(str)) continue;
            return enumVal;
        }
        String msg = "no enum value " + TableFieldTypeEnum.class + "." + str;
        throw new IllegalArgumentException(msg);
    }

    public static boolean kvHiveTypesMatch(FieldDef kvFieldDef, TypeInfo hiveColumnType) {
        Log LOG = LogFactory.getLog(TableFieldTypeEnum.class.getName());
        FieldDef.Type kvFieldType = kvFieldDef.getType();
        if (!(TableFieldTypeEnum.fromKvType(kvFieldType).equals((Object)TableFieldTypeEnum.fromHiveType(hiveColumnType, kvFieldType)) || TABLE_FIELD_ENUM.equals((Object)TableFieldTypeEnum.fromKvType(kvFieldType)) && TABLE_FIELD_STRING.equals((Object)TableFieldTypeEnum.fromHiveType(hiveColumnType)))) {
            LOG.error("Field type MISMATCH: " + (Object)((Object)TableFieldTypeEnum.fromKvType(kvFieldType)) + " != " + (Object)((Object)TableFieldTypeEnum.fromHiveType(hiveColumnType, kvFieldType)));
            return false;
        }
        if (TableFieldTypeEnum.isPrimitive(kvFieldType) && TableFieldTypeEnum.isPrimitive(hiveColumnType)) {
            return true;
        }
        switch (kvFieldType) {
            case ENUM: {
                if (!TABLE_FIELD_STRING.equals((Object)TableFieldTypeEnum.fromHiveType(hiveColumnType))) {
                    LOG.error("Field type MISMATCH: for KV ENUM field type, expected Hive STRING column type, but Hive column type is " + hiveColumnType.getTypeName());
                    return false;
                }
                return true;
            }
            case ARRAY: {
                if (!ObjectInspector.Category.LIST.equals((Object)hiveColumnType.getCategory())) {
                    LOG.error("Field type MISMATCH: for KV ARRAY field type, expected Hive LIST column type, but Hive column type is " + hiveColumnType.getCategory());
                    return false;
                }
                TypeInfo hiveElementType = ((ListTypeInfo)hiveColumnType).getListElementTypeInfo();
                ArrayValue kvArrayValue = kvFieldDef.createArray();
                ArrayDef kvArrayDef = kvArrayValue.getDefinition();
                FieldDef kvElementDef = kvArrayDef.getElement();
                LOG.debug("KV ARRAY field type and Hive LIST column type: comparing KV ARRAY element type [" + kvElementDef.getType() + "] with Hive LIST element type [" + hiveElementType + "]");
                return TableFieldTypeEnum.kvHiveTypesMatch(kvElementDef, hiveElementType);
            }
            case MAP: {
                if (!ObjectInspector.Category.MAP.equals((Object)hiveColumnType.getCategory())) {
                    LOG.error("Field type MISMATCH: for KV MAP field type, expected Hive MAP column type, but Hive column type is " + hiveColumnType.getCategory());
                    return false;
                }
                TypeInfo hiveMapKeyType = ((MapTypeInfo)hiveColumnType).getMapKeyTypeInfo();
                TypeInfo hiveMapValType = ((MapTypeInfo)hiveColumnType).getMapValueTypeInfo();
                if (!TABLE_FIELD_STRING.equals((Object)TableFieldTypeEnum.fromHiveType(hiveMapKeyType))) {
                    LOG.error("Field type MISMATCH: for KV MAP field type and Hive MAP column type, expected STRING key type, but Hive MAP column's key type is " + (Object)((Object)TableFieldTypeEnum.fromHiveType(hiveMapKeyType)));
                    return false;
                }
                MapValue kvMapValue = kvFieldDef.createMap();
                MapDef kvMapDef = kvMapValue.getDefinition();
                FieldDef kvMapValueDef = kvMapDef.getElement();
                LOG.debug("KV MAP field type and Hive MAP column type: comparing KV MAP value type [" + kvMapValueDef.getType() + "] with Hive MAP value type [" + hiveMapValType + "]");
                return TableFieldTypeEnum.kvHiveTypesMatch(kvMapValueDef, hiveMapValType);
            }
            case RECORD: {
                if (!ObjectInspector.Category.STRUCT.equals((Object)hiveColumnType.getCategory())) {
                    LOG.error("Field type MISMATCH: for KV RECORD field type, expected Hive STRUCT column type, but Hive column type is " + hiveColumnType.getCategory());
                    return false;
                }
                ArrayList hiveRecFieldNames = ((StructTypeInfo)hiveColumnType).getAllStructFieldNames();
                RecordValue kvRecValue = kvFieldDef.createRecord();
                RecordDef kvRecDef = kvRecValue.getDefinition();
                List<String> kvRecFieldNames = kvRecDef.getFieldNames();
                if (hiveRecFieldNames.size() != kvRecFieldNames.size()) {
                    LOG.error("Field type MISMATCH: for KV RECORD field type and Hive STRUCT column type, number of KV RECORD elements [" + kvRecFieldNames.size() + "] != number of Hive STRUCT elements [" + hiveRecFieldNames.size() + "]. \nKV RECORD element names = " + kvRecFieldNames + "\nHive STRUCT element names = " + hiveRecFieldNames);
                    return false;
                }
                ArrayList<String> hiveNamesLower = new ArrayList<String>();
                for (String name : hiveRecFieldNames) {
                    hiveNamesLower.add(name.toLowerCase());
                }
                for (String kvRecFieldName : kvRecFieldNames) {
                    String kvFieldLower = kvRecFieldName.toLowerCase();
                    if (!hiveNamesLower.contains(kvFieldLower)) {
                        LOG.error("Field type MISMATCH: for KV RECORD field type and Hive STRUCT column type, KV RECORD element name [" + kvFieldLower + "] does NOT MATCH any Hive STRUCT element names " + hiveNamesLower);
                        return false;
                    }
                    TypeInfo hiveRecFieldType = TableFieldTypeEnum.getStructFieldTypeInfo(kvRecFieldName, (StructTypeInfo)hiveColumnType);
                    FieldDef kvRecFieldDef = kvRecDef.getFieldDef(kvRecFieldName);
                    if (TableFieldTypeEnum.kvHiveTypesMatch(kvRecFieldDef, hiveRecFieldType)) continue;
                    LOG.error("Field type MISMATCH: for KV RECORD field type and Hive STRUCT column type, KV RECORD element type [" + kvRecFieldDef.getType() + "] does NOT MATCH the corresponding Hive STRUCT element type [" + hiveRecFieldType + "]");
                    return false;
                }
                return true;
            }
        }
        LOG.error("Field type MISMATCH: UNKNOWN KV field type [" + kvFieldType + "]");
        return false;
    }

    private static boolean isPrimitive(FieldDef.Type kvType) {
        switch (kvType) {
            case ENUM: {
                return false;
            }
            case ARRAY: {
                return false;
            }
            case MAP: {
                return false;
            }
            case RECORD: {
                return false;
            }
        }
        return true;
    }

    private static boolean isPrimitive(TypeInfo hiveType) {
        return ObjectInspector.Category.PRIMITIVE.equals((Object)hiveType.getCategory());
    }

    private static TypeInfo getStructFieldTypeInfo(String elementName, StructTypeInfo structTypeInfo) {
        String elementLower = elementName.toLowerCase();
        ArrayList allStructFieldNames = structTypeInfo.getAllStructFieldNames();
        ArrayList allStructFieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
        for (int i = 0; i < allStructFieldNames.size(); ++i) {
            String fieldLower = ((String)allStructFieldNames.get(i)).toLowerCase();
            if (!fieldLower.equals(elementLower)) continue;
            return (TypeInfo)allStructFieldTypeInfos.get(i);
        }
        throw new RuntimeException("cannot find STRUCT element [name=" + elementName + "] in " + allStructFieldNames);
    }
}

