/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.events;

import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.events.Address;
import org.eclipse.persistence.testing.models.events.EmailAccount;
import org.eclipse.persistence.testing.models.events.Phone;
import org.eclipse.persistence.testing.tests.events.EventHookTestCase;

public class UpdateEventHookTest
extends EventHookTestCase {
    @Override
    public void setup() {
        super.setup();
        this.getDatabaseSession().insertObject((Object)this.getEmailAccount());
        this.getDatabaseSession().insertObject((Object)this.getPhoneNumber());
        this.getDatabaseSession().insertObject((Object)this.getAddress());
    }

    protected void test() {
        EmailAccount emailAccount = this.getEmailAccount();
        Phone phone = this.getPhoneNumber();
        Address address = this.getAddress();
        emailAccount.setHostName("test.usenet.net");
        phone.phoneNo = new String("234-3453");
        address.address = new String("XYZ, I M Here");
        this.getDatabaseSession().updateObject((Object)emailAccount);
        this.getDatabaseSession().updateObject((Object)phone);
        this.getDatabaseSession().updateObject((Object)address);
    }

    protected void verify() {
        if (!this.getEmailAccount().preUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The pre update method on " + this.getEmailAccount() + " failed to execute.");
        }
        if (!this.getEmailAccount().postUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The post update method on " + this.getEmailAccount() + " failed to execute.");
        }
        if (!this.getEmailAccount().aboutToUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The about to update method on " + this.getEmailAccount() + " failed to execute.");
        }
        if (!this.getPhoneNumber().preUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The pre update method on " + this.getPhoneNumber() + " failed to execute.");
        }
        if (!this.getPhoneNumber().postUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The post update method on " + this.getPhoneNumber() + " failed to execute.");
        }
        if (!this.getPhoneNumber().aboutToUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The about to update method on " + this.getPhoneNumber() + " failed to execute.");
        }
        if (!this.getAddressListener().preUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The pre update method on " + this.getAddressListener() + " failed to execute.");
        }
        if (!this.getAddressListener().postUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The post update method on " + this.getAddressListener() + " failed to execute.");
        }
        if (!this.getAddressListener().aboutToUpdateExecuted) {
            throw new TestErrorException("Event hook failed. The about to update method on " + this.getAddressListener() + " failed to execute.");
        }
    }
}

