/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.remote.RemoteModel;

public class PessimisticLockIndirectionJoiningTest
extends TestCase {
    public UnitOfWork uow;
    public short lockMode;
    CMPPolicy oldCMPPolicy;
    public int joining;
    ArrayList oldJoinedAttributes;

    public PessimisticLockIndirectionJoiningTest(short lockMode) {
        this.lockMode = lockMode;
        this.setName(this.getName() + "(mode=" + lockMode + ")");
        this.setDescription("This test verifies the pessimistic locking feature works properly when set on the descriptor.");
    }

    protected void setup() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        CMPPolicy cmpPolicy = new CMPPolicy();
        PessimisticLockingPolicy policy = new PessimisticLockingPolicy();
        policy.setLockingMode(this.lockMode);
        cmpPolicy.setPessimisticLockingPolicy(policy);
        ClassDescriptor addressDescriptor = this.getSession().getDescriptor(Address.class);
        this.oldCMPPolicy = addressDescriptor.getCMPPolicy();
        addressDescriptor.setCMPPolicy(cmpPolicy);
        addressDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        employeeDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ObjectLevelReadQuery selectionQuery = (ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery();
        selectionQuery.setLockMode((short)-1);
        OneToOneMapping addressMapping = (OneToOneMapping)employeeDescriptor.getMappingForAttributeName("address");
        this.joining = addressMapping.getJoinFetch();
        this.oldJoinedAttributes = (ArrayList)((ArrayList)selectionQuery.getJoinedAttributeManager().getJoinedMappingExpressions()).clone();
        addressMapping.setJoinFetch(1);
        employeeDescriptor.reInitializeJoinedAttributes();
        ClassDescriptor projectDescriptor = this.getSession().getDescriptor(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        ObjectLevelReadQuery projectSelectionQuery = (ObjectLevelReadQuery)((ForeignReferenceMapping)projectDescriptor.getMappingForAttributeName("teamLeader")).getSelectionQuery();
        projectSelectionQuery.setLockMode((short)-1);
    }

    public void test() throws Exception {
        this.checkSelectForUpateSupported();
        if (this.lockMode == 2) {
            this.checkNoWaitSupported();
        }
        this.uow = this.getSession().acquireUnitOfWork();
        ReadObjectQuery query = new ReadObjectQuery(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        Expression expression = query.getExpressionBuilder().get("teamLeader").get("address").get("city").equal((Object)"Ottawa");
        query.setSelectionCriteria(expression);
        org.eclipse.persistence.testing.models.employee.domain.Project readInProject = (org.eclipse.persistence.testing.models.employee.domain.Project)this.uow.executeQuery((DatabaseQuery)query);
        readInProject.getTeamLeader();
        DatabaseSession session2 = null;
        UnitOfWork uow2 = null;
        try {
            Project project = null;
            project = this.getSession() instanceof RemoteSession ? RemoteModel.getServerSession().getProject() : this.getSession().getProject();
            project = project.clone();
            project.setLogin((DatabaseLogin)project.getLogin().clone());
            session2 = project.createDatabaseSession();
            session2.setLog(this.getSession().getLog());
            session2.setLogLevel(this.getSession().getLogLevel());
            session2.login();
            uow2 = session2.acquireUnitOfWork();
            ReadAllQuery doomedQuery = new ReadAllQuery(Address.class);
            expression = query.getExpressionBuilder().get("city").equal((Object)"Ottawa");
            doomedQuery.setSelectionCriteria(expression);
            boolean isLocked = false;
            try {
                List addresses = (List)uow2.executeQuery((DatabaseQuery)doomedQuery);
                addresses.toString();
            }
            catch (EclipseLinkException exeception) {
                isLocked = true;
            }
            if (!isLocked) {
                throw new TestErrorException("Select for update does not acquire a lock");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (uow2 != null) {
                uow2.release();
            }
            if (session2 != null) {
                session2.logout();
            }
        }
    }

    public void reset() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        if (this.uow != null) {
            this.uow.release();
        }
        ClassDescriptor addressDescriptor = this.getSession().getDescriptor(Address.class);
        addressDescriptor.setCMPPolicy(this.oldCMPPolicy);
        addressDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ClassDescriptor employeeDescriptor = this.getSession().getDescriptor(Employee.class);
        employeeDescriptor.getQueryManager().getReadObjectQuery().setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery()).setLockMode((short)-1);
        ((ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery()).dontRefreshIdentityMapResult();
        ObjectLevelReadQuery selectionQuery = (ObjectLevelReadQuery)((ForeignReferenceMapping)employeeDescriptor.getMappingForAttributeName("address")).getSelectionQuery();
        selectionQuery.setLockMode((short)-1);
        selectionQuery.getJoinedAttributeManager().setJoinedMappingExpressions_((List)this.oldJoinedAttributes);
        OneToOneMapping addressMapping = (OneToOneMapping)employeeDescriptor.getMappingForAttributeName("address");
        addressMapping.setJoinFetch(this.joining);
        employeeDescriptor.reInitializeJoinedAttributes();
        ClassDescriptor projectDescriptor = this.getSession().getDescriptor(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        ObjectLevelReadQuery projectSelectionQuery = (ObjectLevelReadQuery)((ForeignReferenceMapping)projectDescriptor.getMappingForAttributeName("teamLeader")).getSelectionQuery();
        projectSelectionQuery.setLockMode((short)-1);
    }
}

