/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.workbenchintegration;

import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.Location;
import org.eclipse.persistence.testing.tests.workbenchintegration.ProjectXMLSortedCollectionMapping;

public class ProjectXMLSortedCollectionMappingWithInvalidComparatorTest
extends ProjectXMLSortedCollectionMapping {
    public ProjectXMLSortedCollectionMappingWithInvalidComparatorTest() {
        this.setDescription("Tests sorted collection mapping with specified comparator can be written to or read from project XML correctly.");
    }

    @Override
    protected void verify() {
        if (this.exception != null) {
            if (this.exception.getMessage().indexOf("is not a valid comparator") == -1) {
                throw new TestErrorException("There is problem when read project back from project.xml", (Throwable)this.exception);
            }
        } else {
            throw new TestErrorException("ValidationException is expected to be caught for this test case");
        }
    }

    @Override
    public Class<?> getComparator() {
        return ProjectComparator.class;
    }

    public static class ProjectComparator {
        public int compare(Object object1, Object object2) {
            if (object1.getClass() != Project.class || object2.getClass() != Project.class) {
                throw new ClassCastException("Invalid comparison : " + object1 + ", " + object2);
            }
            Location loc1 = (Location)object1;
            Location loc2 = (Location)object2;
            return String.CASE_INSENSITIVE_ORDER.compare(loc1.getArea(), loc2.getArea());
        }
    }
}

