/*
 * Copyright (c) 2011, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//     Oracle - initial API and implementation
//
package org.eclipse.persistence.jpa.jpql.tools.model;

import org.eclipse.persistence.jpa.jpql.tools.model.query.SelectClauseStateObject;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;

/**
 * @version 2.4
 * @since 2.4
 * @author Pascal Filion
 */
public abstract class AbstractEclipseLinkSelectExpressionStateObjectBuilder extends AbstractSelectExpressionStateObjectBuilder
                                                                            implements IEclipseLinkSelectExpressionStateObjectBuilder {

    /**
     * Creates a new <code>AbstractEclipseLinkSelectExpressionStateObjectBuilder</code>.
     *
     * @param parent The select clause for which this builder can create a select expression
     */
    protected AbstractEclipseLinkSelectExpressionStateObjectBuilder(SelectClauseStateObject parent) {
        super(parent);
    }

    @Override
    public IEclipseLinkSelectExpressionStateObjectBuilder append() {
        return (IEclipseLinkSelectExpressionStateObjectBuilder) super.append();
    }

    @Override
    public IEclipseLinkSelectExpressionStateObjectBuilder new_(String className,
                                                               ISelectExpressionStateObjectBuilder... parameters) {

        return (IEclipseLinkSelectExpressionStateObjectBuilder) super.new_(className, parameters);
    }

    @Override
    public IEclipseLinkSelectExpressionStateObjectBuilder object(String identificationVariable) {
        return (IEclipseLinkSelectExpressionStateObjectBuilder) super.object(identificationVariable);
    }

    @Override
    public IEclipseLinkSelectExpressionStateObjectBuilder resultVariable(String resultVariable) {
        return (IEclipseLinkSelectExpressionStateObjectBuilder) super.resultVariable(resultVariable);
    }

    @Override
    public IEclipseLinkSelectExpressionStateObjectBuilder resultVariableAs(String resultVariable) {
        return (IEclipseLinkSelectExpressionStateObjectBuilder) super.resultVariableAs(resultVariable);
    }

    @Override
    public IEclipseLinkSelectExpressionStateObjectBuilder variable(String variable) {
        StateObject stateObject = buildIdentificationVariable(variable);
        add(stateObject);
        return this;
    }
}
