/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.cache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.CacheIndex;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class CacheIndexMetadata
extends ORMetadata {
    private List<String> m_columnNames = new ArrayList<String>();
    private Boolean updateable;

    public CacheIndexMetadata() {
        super("<cache-index>");
    }

    public CacheIndexMetadata(MetadataAnnotation index, MetadataAccessor accessor) {
        super(index, accessor);
        if (index != null) {
            for (Object columnName : index.getAttributeArray("columnNames")) {
                this.m_columnNames.add((String)columnName);
            }
            this.updateable = index.getAttributeBooleanDefaultTrue("updateable");
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof CacheIndexMetadata) {
            CacheIndexMetadata index = (CacheIndexMetadata)objectToCompare;
            if (this.updateable != index.getUpdateable()) {
                return false;
            }
            return this.m_columnNames.equals(index.getColumnNames());
        }
        return false;
    }

    public int hashCode() {
        int result = this.m_columnNames != null ? this.m_columnNames.hashCode() : 0;
        result = 31 * result + (this.updateable != null ? this.updateable.hashCode() : 0);
        return result;
    }

    public List<String> getColumnNames() {
        return this.m_columnNames;
    }

    public Boolean getUpdateable() {
        return this.updateable;
    }

    public void process(MetadataDescriptor descriptor, String defaultColumnName) {
        CacheIndex index = new CacheIndex();
        if (this.m_columnNames.isEmpty() && defaultColumnName != null) {
            index.addField(this.getField(defaultColumnName));
        } else {
            for (String column : this.m_columnNames) {
                index.addField(this.getField(column));
            }
        }
        if (this.updateable != null) {
            index.setIsUpdateable(this.updateable);
        }
        descriptor.getClassDescriptor().getCachePolicy().addCacheIndex(index);
    }

    public void setColumnNames(List<String> columnNames) {
        this.m_columnNames = columnNames;
    }

    public void setUpdateable(Boolean updateable) {
        this.updateable = updateable;
    }

    private DatabaseField getField(String name) {
        DatabaseField field = new DatabaseField(name);
        if (this.m_project.useDelimitedIdentifier()) {
            field.setUseDelimiters(true);
        } else if (this.m_project.getShouldForceFieldNamesToUpperCase() && !field.shouldUseDelimiters()) {
            field.useUpperCaseForComparisons(true);
        }
        return field;
    }
}

