/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.aggregate.Agent;
import org.eclipse.persistence.testing.models.aggregate.Builder;
import org.eclipse.persistence.testing.models.aggregate.House;
import org.eclipse.persistence.testing.models.aggregate.RoomSellingPoint;
import org.eclipse.persistence.testing.tests.aggregate.AgentBuilderHelper;

public class NestedAggregateCollectionAbstractTestCase
extends AutoVerifyTestCase {
    public Class<?> cls;
    public boolean instantiationExceptionOccurred = false;

    public NestedAggregateCollectionAbstractTestCase(Class<?> cls) {
        this.cls = cls;
        this.setName(this.getName() + AgentBuilderHelper.getNameInBrackets(cls));
    }

    public void reset() {
        this.rollbackTransaction();
    }

    public void setup() {
        this.beginTransaction();
    }

    public void test() {
        try {
            UnitOfWork uow = this.getSession().acquireUnitOfWork();
            Serializable instance = Agent.class.equals(this.cls) ? Agent.example1() : Builder.example1();
            ExpressionBuilder builder = new ExpressionBuilder();
            Expression exp = builder.get("firstName").equal((Object)AgentBuilderHelper.getFirstName(instance));
            exp = exp.and(builder.get("lastName").equal((Object)AgentBuilderHelper.getLastName(instance)));
            Object clone = uow.readObject(this.cls, exp);
            uow.commitAndResume();
            House h1 = (House)AgentBuilderHelper.getHouses(instance).get(0);
            Vector sellingPoints = h1.getSellingPoints();
            sellingPoints.add(RoomSellingPoint.example4());
            uow.deepMergeClone((Object)instance);
            uow.commit();
        }
        catch (Exception exp) {
            this.instantiationExceptionOccurred = true;
        }
    }

    public void verify() {
        if (this.instantiationExceptionOccurred) {
            throw new TestErrorException("EclipseLink attempted to merge an abstract class, when merging an aggregate collection.");
        }
    }
}

