/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.conversion;

import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;

public class ConvertClassTypeTest
extends AutoVerifyTestCase {
    protected boolean m_failure;
    protected String m_testStr;
    protected Class<?> m_testClass;
    protected Class<?> m_type;

    public ConvertClassTypeTest(String testStr, Class<?> type) {
        this.m_testStr = testStr;
        this.m_testClass = null;
        this.m_type = type;
    }

    public ConvertClassTypeTest(Class<?> testClass, Class<?> type) {
        this.m_testClass = testClass;
        this.m_testStr = null;
        this.m_type = type;
    }

    public void setup() {
        this.m_failure = false;
    }

    public void test() {
        if (this.m_testClass == null) {
            if (ConversionManager.getPrimitiveClass((String)this.m_testStr) != this.m_type) {
                this.m_failure = true;
            }
        } else if (ConversionManager.getObjectClass(this.m_testClass) != this.m_type) {
            this.m_failure = true;
        }
    }

    public void verify() {
        if (this.m_failure) {
            throw new TestErrorException("Conversion of '" + this.m_testClass + "' to '" + this.m_type + "' falied.");
        }
    }

    public void reset() {
        this.m_failure = false;
        this.m_testStr = "";
        this.m_testClass = null;
        this.m_type = null;
    }
}

