/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.customsqlstoredprocedures;

import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class CustomSQLCursoredStreamReadTest
extends AutoVerifyTestCase {
    protected boolean m_exceptionCaughtOnSQLQueryExecution;
    protected boolean m_exceptionCaughtOnSizeQueryExecution;

    public CustomSQLCursoredStreamReadTest() {
        this.setDescription("Tests that the additionalSizeQueryNotSpecified exception is thrown at the right time for a custom sql query.");
    }

    protected void setup() {
        this.m_exceptionCaughtOnSQLQueryExecution = false;
        this.m_exceptionCaughtOnSizeQueryExecution = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() {
        ReadAllQuery query = new ReadAllQuery(Employee.class);
        query.setSQLString("SELECT * FROM EMPLOYEE");
        query.useCursoredStream();
        try (CursoredStream stream = null;){
            stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
            try {
                stream.size();
            }
            catch (Exception e) {
                this.m_exceptionCaughtOnSizeQueryExecution = true;
            }
        }
    }

    protected void verify() throws Exception {
        if (this.m_exceptionCaughtOnSQLQueryExecution) {
            throw new TestErrorException("The additionalSizeQueryNotSpecified exception was thrown when preparing the custom sql query.");
        }
        if (!this.m_exceptionCaughtOnSizeQueryExecution) {
            throw new TestErrorException("The additionalSizeQueryNotSpecified exception was not thrown when size was called on the cursored stream.");
        }
    }
}

