/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class NestedUnitOfWorkReadOnlyClassTest
extends AutoVerifyTestCase {
    private String postalCode;
    private Employee originalEmployee;
    private Address originalAddress;

    public NestedUnitOfWorkReadOnlyClassTest() {
        this.setDescription("Nested Unit Of Work with Read Only class");
    }

    public void setup() {
        if (!this.isSequenceNumberEnabled()) {
            throw new TestWarningException("This test uses sequence numbers.");
        }
        this.getAbstractSession().beginTransaction();
        this.postalCode = "AB7J98";
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Address address = (Address)uow.registerObject((Object)new Address());
        uow.assignSequenceNumber((Object)address);
        address.setPostalCode(this.postalCode);
        address.setCity("Toronto");
        address.setCountry("CANADA");
        uow.commit();
        this.getAbstractSession().commitTransaction();
        this.originalAddress = address;
    }

    public void reset() {
        if (!this.isSequenceNumberEnabled()) {
            return;
        }
        UnitOfWork deleteUOW = this.getSession().acquireUnitOfWork();
        deleteUOW.deleteObject(deleteUOW.readObject((Object)this.originalAddress));
        deleteUOW.deleteObject(deleteUOW.readObject((Object)this.originalEmployee));
        deleteUOW.commit();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        UnitOfWork rootUOW = this.getSession().acquireUnitOfWork();
        Address addressRO = (Address)this.getSession().readObject(Address.class, new ExpressionBuilder().get("postalCode").equal((Object)this.postalCode));
        if (addressRO == null) {
            throw new TestErrorException("Unable to find address.");
        }
        UnitOfWork nestedUOW = rootUOW.acquireUnitOfWork();
        nestedUOW.addReadOnlyClass(Address.class);
        Employee emp = (Employee)nestedUOW.registerObject((Object)new Employee());
        nestedUOW.assignSequenceNumber((Object)emp);
        emp.setFirstName("John");
        emp.setAddress(addressRO);
        nestedUOW.commit();
        rootUOW.commit();
        this.originalEmployee = emp;
    }

    protected void verify() {
    }

    protected boolean isSequenceNumberEnabled() {
        return this.getAbstractSession().getDescriptor(Employee.class).usesSequenceNumbers();
    }
}

