/*
 * Copyright (c) 2011, 2021 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
// dmccann - August 5/2010 - 2.2 - Initial implementation
package org.eclipse.persistence.testing.jaxb.externalizedmetadata.mappings.xmltransformation;

import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;

public class NormalHoursAttributeTransformer implements AttributeTransformer {
    @Override
    public void initialize(AbstractTransformationMapping mapping) {}

    @Override
    public Object buildAttributeValue(DataRecord dataRecord, Object instance, Session session) {
        String[] hours = new String[2];
        hours[0] = (String) dataRecord.get("normal-hours/start-time/text()");
        hours[1] = (String) dataRecord.get("normal-hours/end-time/text()");
        return hours;
    }
}
