/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.kv.Key;
import oracle.kv.impl.api.lob.ChunkKeyFactory;

class ChunkKeysIterator
implements Iterator<Key>,
Cloneable {
    final Key internalLobKey;
    final int chunksPerPartition;
    final long limitChunks;
    final ChunkKeyFactory keyFactory;
    private long lcindex;

    ChunkKeysIterator(Key internalLobKey, long byteIndex, long maxByteIndex, int chunkSize, int chunksPerPartition, ChunkKeyFactory keyFactory) {
        if (byteIndex < 0L || chunkSize <= 0 || chunksPerPartition <= 0) {
            throw new IllegalStateException("Byte index:" + byteIndex + " chunk size:" + chunkSize + " chunks per partition:" + chunksPerPartition);
        }
        if (byteIndex > maxByteIndex) {
            throw new IllegalStateException("Byte index:" + byteIndex + " > max byte index:" + maxByteIndex);
        }
        this.internalLobKey = internalLobKey;
        this.chunksPerPartition = chunksPerPartition;
        this.lcindex = byteIndex / (long)chunkSize;
        this.limitChunks = maxByteIndex == 0L ? 0L : (maxByteIndex - 1L) / (long)chunkSize + 1L;
        this.keyFactory = keyFactory;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    long getChunkId() {
        if (this.lcindex == 0L) {
            throw new IllegalStateException("next( has not yet been invoked.");
        }
        long chunkId = (this.lcindex - 1L) % (long)this.chunksPerPartition + 1L;
        if (chunkId <= 0L) {
            throw new IllegalStateException("current chunk index:" + this.lcindex + " cid:" + chunkId);
        }
        return chunkId;
    }

    long getSuperChunkId() {
        if (this.lcindex == 0L) {
            throw new IllegalStateException("next( has not yet been invoked.");
        }
        return (this.lcindex - 1L) / (long)this.chunksPerPartition + 1L;
    }

    void reset(ChunkKeysIterator i) {
        this.lcindex = i.lcindex;
    }

    long skip(long skipChunks) {
        if (skipChunks < 0L) {
            throw new IllegalArgumentException("skip chunks: " + skipChunks);
        }
        if (skipChunks == 0L) {
            return 0L;
        }
        long savedLcindex = this.lcindex;
        this.lcindex += skipChunks;
        if (this.lcindex > this.limitChunks) {
            this.lcindex = this.limitChunks;
        }
        return this.lcindex - savedLcindex;
    }

    long currentChunkIndex() {
        return this.lcindex;
    }

    @Override
    public boolean hasNext() {
        return this.lcindex < this.limitChunks;
    }

    @Override
    public Key next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("current chunk index:" + this.lcindex + " max:" + this.limitChunks);
        }
        ++this.lcindex;
        return this.keyFactory.create(this.internalLobKey, this.getSuperChunkId(), this.getChunkId());
    }

    public boolean backup() {
        if (this.lcindex > 0L) {
            --this.lcindex;
            return true;
        }
        return false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Method not implemented: remove");
    }

    public String toString() {
        return "<ChunkKeysIterator  lob version:" + this.keyFactory.getMetadataVersion() + " lcid:" + this.lcindex + " limit chunks:" + this.limitChunks + " scid: " + (this.lcindex != 0L ? this.getSuperChunkId() : -1L) + " chunkId: " + (this.lcindex != 0L ? this.getChunkId() : -1L) + ">";
    }
}

