/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.fault;

public enum ProcessExitCode {
    RESTART{

        @Override
        public short getValue() {
            return 200;
        }

        @Override
        public boolean needsRestart() {
            return true;
        }
    }
    ,
    NO_RESTART{

        @Override
        public short getValue() {
            return 201;
        }

        @Override
        public boolean needsRestart() {
            return false;
        }
    }
    ,
    RESTART_OOME{

        @Override
        public short getValue() {
            return 202;
        }

        @Override
        public boolean needsRestart() {
            return true;
        }
    };


    public abstract short getValue();

    public abstract boolean needsRestart();

    public static boolean needsRestart(int exitCode) {
        for (ProcessExitCode v : ProcessExitCode.values()) {
            if (exitCode != v.getValue()) continue;
            return v.needsRestart();
        }
        return true;
    }
}

