/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class FormatUtils {
    public static String defaultTimeZone = "UTC";
    private static final TimeZone tz = TimeZone.getTimeZone(defaultTimeZone);

    public static TimeZone getTimeZone() {
        return tz;
    }

    public static DateFormat getDateTimeAndTimeZoneFormatter() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        df.setTimeZone(tz);
        return df;
    }

    public static String formatTime(long time) {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS z");
        formatter.setTimeZone(tz);
        return formatter.format(new Date(time));
    }

    public static String formatPerfTime(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
        df.setTimeZone(tz);
        return df.format(new Date(time));
    }

    public static String formatDateAndTime(long time) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        formatter.setTimeZone(tz);
        return formatter.format(new Date(time));
    }
}

