/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.sklogger;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.kv.impl.util.JsonUtils;
import oracle.kv.impl.util.contextlogger.ContextFormatter;
import oracle.kv.impl.util.contextlogger.ContextLogManager;
import oracle.kv.impl.util.contextlogger.LogContext;
import oracle.kv.impl.util.sklogger.Metric;
import oracle.kv.impl.util.sklogger.MetricFamilySamples;
import oracle.kv.impl.util.sklogger.MetricProcessor;
import oracle.kv.impl.util.sklogger.StringEvent;
import oracle.kv.impl.util.sklogger.StringEventProcessor;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;

public class SkLogger
implements MetricProcessor,
StringEventProcessor {
    public static final String COMPONENTID_ENV = "componentId";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String SK_HANDLERS = ".skhandlers";
    private static final String SK_FILEHANDLER = "skfilehandler";
    private static final String SK_CONSOLEHANDLER = "skconsolehandler";
    private static final String SK_FILEHANDLER_DIR = "SkFileHandler.dir";
    private static final String SK_FILEHANDLER_COUNT = "SkFileHandler.count";
    private static final String SK_FILEHANDLER_LIMIT = "SkFileHandler.limit";
    private static final String SK_FILEHANDLER_APPEND = "SkFileHandler.append";
    private static final String SK_FILEHANDLER_LEVEL = "SkFileHandler.level";
    private static final String SK_CONSOLEHANDLER_LEVEL = "SkConsoleHandler.level";
    private static final ConcurrentHashMap<String, FileHandler> FILE_HANDLER_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> LOG_FILE_MAP = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> properties = new ConcurrentHashMap();
    private Logger logger;
    private int minHandlerLevel = Level.OFF.intValue();

    public SkLogger(Logger logger) {
        this.resetLogger(logger);
    }

    public SkLogger(String loggerName, String componentId) {
        this(loggerName, componentId, componentId + ".log");
    }

    public SkLogger(String loggerName, String componentId, boolean useSkConfig) {
        this.logger = SkLogger.getLogger(loggerName, componentId);
        if (useSkConfig) {
            this.addHandlers(componentId, componentId + ".log");
        }
    }

    public SkLogger(String loggerName, String componentId, String fileName) {
        this.logger = SkLogger.getLogger(loggerName, componentId);
        this.addHandlers(componentId, fileName);
    }

    private static Logger getLogger(String loggerName, String componentId) {
        String name = loggerName + "." + componentId.replace('.', '_');
        Logger logger = Logger.getLogger(name);
        logger.setUseParentHandlers(false);
        return logger;
    }

    public void resetLogger(Logger newLogger) {
        this.logger = newLogger;
        Handler[] handlers = newLogger.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                this.minHandlerLevel = Math.min(h.getLevel().intValue(), this.minHandlerLevel);
            }
        }
    }

    public static SkLogger getSkLoggerWithConsole(String loggerName, String componentId) {
        SkLogger sklogger = new SkLogger(loggerName, componentId, false);
        ConsoleHandler handler = new ConsoleHandler(componentId, Level.ALL);
        sklogger.addHandler(handler);
        return sklogger;
    }

    @Override
    public void process(MetricFamilySamples<?> metricFamily) {
        if (metricFamily == null) {
            return;
        }
        if (!this.isLoggable(MonitorLevel.METRIC)) {
            return;
        }
        String name = metricFamily.getName();
        List<String> labelNames = metricFamily.getLabelNames();
        for (MetricFamilySamples.Sample<?> sample : metricFamily.getSamples()) {
            ObjectNode jsonRoot = this.createJsonHeader();
            for (int i = 0; i < labelNames.size(); ++i) {
                String fullName = name + "_" + labelNames.get(i);
                String labelValue = sample.labelValues.get(i);
                jsonRoot.put(fullName, labelValue);
            }
            for (Map.Entry<String, Object> entry : ((Metric.Result)sample.dataValue).toMap().entrySet()) {
                Number val;
                String key = entry.getKey();
                String fullName = key.isEmpty() ? name : name + "_" + entry.getKey();
                Object dataValue = entry.getValue();
                if (dataValue instanceof Double) {
                    val = (Double)dataValue;
                    if (Double.isNaN((Double)val) || Double.isInfinite((Double)val)) {
                        jsonRoot.put(fullName, 0.0);
                        continue;
                    }
                    jsonRoot.put(fullName, (Double)val);
                    continue;
                }
                if (dataValue instanceof Float) {
                    val = (Float)dataValue;
                    if (Float.isNaN(((Float)val).floatValue()) || Float.isInfinite(((Float)val).floatValue())) {
                        jsonRoot.put(fullName, 0.0);
                        continue;
                    }
                    jsonRoot.put(fullName, (Float)val);
                    continue;
                }
                if (dataValue instanceof Long) {
                    jsonRoot.put(fullName, (Long)dataValue);
                    continue;
                }
                if (dataValue instanceof Integer) {
                    jsonRoot.put(fullName, (Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    jsonRoot.put(fullName, (Boolean)dataValue);
                    continue;
                }
                jsonRoot.put(fullName, entry.getValue().toString());
            }
            ObjectWriter writer = JsonUtils.createWriter(false);
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(writer.writeValueAsString(jsonRoot));
                LogRecord record = new LogRecord(MonitorLevel.METRIC, sb.toString());
                SkLogger.setLogRecordMillis(record, metricFamily.getReportTimeMs());
                this.logger.log(record);
            }
            catch (IOException iOException) {}
        }
    }

    private static void setLogRecordMillis(LogRecord record, long millis) {
        record.setMillis(millis);
    }

    @Override
    public void process(StringEvent event) {
        if (event == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(event.getStatsName());
        sb.append(" " + event.getLevel().getLocalizedName());
        sb.append(" " + event.getSubject());
        if (event.getMessage() != null) {
            sb.append(LINE_SEPARATOR + event.getMessage());
        }
        MonitorLevel level = MonitorLevel.getEventLevel(event.getLevel().intValue());
        LogRecord record = new LogRecord(level, sb.toString());
        SkLogger.setLogRecordMillis(record, event.getReportTimeMs());
        record.setThrown(event.getThrown());
        this.logger.log(record);
    }

    public SkLogger setProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    private ObjectNode createJsonHeader() {
        ObjectNode jsonRoot = JsonUtils.createObjectNode();
        if (this.properties != null) {
            for (Map.Entry<String, String> p : this.properties.entrySet()) {
                jsonRoot.put(p.getKey(), p.getValue());
            }
        }
        return jsonRoot;
    }

    private String getSkHandlersProperty(LogManager mgr, String propertyName) {
        String handlersProperty = null;
        while (propertyName != null) {
            handlersProperty = mgr.getProperty(propertyName + SK_HANDLERS);
            if (handlersProperty != null || propertyName.isEmpty()) {
                return handlersProperty;
            }
            int parentIndex = propertyName.lastIndexOf(46);
            if (parentIndex < 0) {
                propertyName = "";
                continue;
            }
            propertyName = propertyName.substring(0, parentIndex);
        }
        return handlersProperty;
    }

    private void addHandlers(String componentId, String fileName) {
        LogManager mgr;
        String handlersProperty;
        String oldFileName = LOG_FILE_MAP.putIfAbsent(this.logger.getName(), fileName);
        if (oldFileName != null && !oldFileName.equals(fileName)) {
            throw new IllegalArgumentException("Don't allow the same loggerName but with different fileName");
        }
        boolean hasConsoleHandler = false;
        boolean hasFileHandler = false;
        Handler[] handlers = this.logger.getHandlers();
        if (handlers != null) {
            for (Handler h : handlers) {
                this.minHandlerLevel = Math.min(h.getLevel().intValue(), this.minHandlerLevel);
                if (h instanceof ConsoleHandler) {
                    hasConsoleHandler = true;
                    continue;
                }
                if (!(h instanceof FileHandler)) continue;
                hasFileHandler = true;
            }
        }
        if ((handlersProperty = this.getSkHandlersProperty(mgr = LogManager.getLogManager(), this.logger.getName())) == null) {
            return;
        }
        handlersProperty = handlersProperty.toLowerCase();
        if (!hasFileHandler && handlersProperty.contains(SK_FILEHANDLER)) {
            Handler existing = FILE_HANDLER_MAP.get(fileName);
            if (existing != null) {
                this.addHandler(existing);
            } else {
                try {
                    FileHandler fileHandler;
                    String dir = mgr.getProperty(SK_FILEHANDLER_DIR);
                    String pattern = "%h/sklogger%u.log";
                    if (dir != null) {
                        File parent = new File(dir);
                        parent.mkdirs();
                        pattern = new File(parent, fileName).getAbsolutePath();
                    }
                    String countProperty = mgr.getProperty(SK_FILEHANDLER_COUNT);
                    int count = 10;
                    if (countProperty != null) {
                        count = Integer.parseInt(countProperty);
                    }
                    String limitProperty = mgr.getProperty(SK_FILEHANDLER_LIMIT);
                    int limit = 2000000;
                    if (limitProperty != null) {
                        limit = Integer.parseInt(limitProperty);
                    }
                    String appendProperty = mgr.getProperty(SK_FILEHANDLER_APPEND);
                    boolean append = true;
                    if (appendProperty != null) {
                        append = Boolean.parseBoolean(appendProperty);
                    }
                    String levelProperty = mgr.getProperty(SK_FILEHANDLER_LEVEL);
                    Level level = Level.ALL;
                    if (levelProperty != null) {
                        level = Level.parse(levelProperty);
                    }
                    if ((existing = (Handler)FILE_HANDLER_MAP.putIfAbsent(fileName, fileHandler = new FileHandler(componentId, pattern, limit, count, append, level))) == null) {
                        this.addHandler(fileHandler);
                    } else {
                        fileHandler.close();
                        this.addHandler(existing);
                    }
                }
                catch (IOException dir) {
                    // empty catch block
                }
            }
        }
        if (!hasConsoleHandler && handlersProperty.contains(SK_CONSOLEHANDLER)) {
            String levelProperty = mgr.getProperty(SK_CONSOLEHANDLER_LEVEL);
            Level level = Level.ALL;
            if (levelProperty != null) {
                level = Level.parse(levelProperty);
            }
            ConsoleHandler handler = new ConsoleHandler(componentId, level);
            this.addHandler(handler);
        }
    }

    public void logEvent(String category, Level level, String subject, String message, Throwable cause) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.process(new StringEvent(category, level, subject, message, cause));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level) && this.minHandlerLevel <= level.intValue();
    }

    public boolean isLoggable(Level level, LogContext lc) {
        if (this.isLoggable(level)) {
            return true;
        }
        if (lc == null) {
            return false;
        }
        int contextLevelValue = lc.getLogLevel();
        return level.intValue() >= contextLevelValue;
    }

    public void addHandler(Handler handler) throws SecurityException {
        this.minHandlerLevel = Math.min(handler.getLevel().intValue(), this.minHandlerLevel);
        this.logger.addHandler(handler);
    }

    public void severe(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void severe(String msg, LogContext lc) {
        this.log(Level.SEVERE, msg, lc);
    }

    public void warning(String msg) {
        this.log(Level.WARNING, msg);
    }

    public void warning(String msg, LogContext lc) {
        this.log(Level.WARNING, msg, lc);
    }

    public void info(String msg) {
        this.log(Level.INFO, msg);
    }

    public void info(String msg, LogContext lc) {
        this.log(Level.INFO, msg, lc);
    }

    public void fine(String msg) {
        this.log(Level.FINE, msg);
    }

    public void fine(String msg, LogContext lc) {
        this.log(Level.FINE, msg, lc);
    }

    public void log(Level level, String msg) {
        this.logger.log(level, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(Level level, String msg, LogContext ctx) {
        try (ContextLogManager.WithLogContext wlc = new ContextLogManager.WithLogContext(ctx);){
            this.log(level, msg);
        }
    }

    public void log(Level level, String msg, Throwable thrown) {
        this.logger.log(level, msg, thrown);
    }

    public void setLevel(Level newLevel) throws SecurityException {
        this.logger.setLevel(newLevel);
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.logger.setUseParentHandlers(useParentHandlers);
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public Logger getParent() {
        return this.logger.getParent();
    }

    public static class ConsoleHandler
    extends java.util.logging.ConsoleHandler {
        public ConsoleHandler(String componentId, Level level) {
            this.setFormatter(new ContextFormatter(componentId));
            this.setLevel(level);
        }
    }

    public static class FileHandler
    extends java.util.logging.FileHandler {
        public FileHandler(String componentId, String pattern, int limit, int count, boolean append, Level level) throws IOException, SecurityException {
            super(pattern, limit, count, append);
            this.setFormatter(new ContextFormatter(componentId));
            this.setLevel(level);
        }
    }

    private static final class MonitorLevel
    extends Level {
        private static final long serialVersionUID = 1L;
        private static final int METRIC_VALUE = 902;
        private static final int EVENT_SEVERE_VALUE = SEVERE.intValue() + 1;
        private static final int EVENT_WARNING_VALUE = WARNING.intValue() + 1;
        private static final int EVENT_INFO_VALUE = INFO.intValue() + 1;
        private static final int EVENT_CONFIG_VALUE = CONFIG.intValue() + 1;
        private static final int EVENT_FINE_VALUE = FINE.intValue() + 1;
        private static final int EVENT_FINER_VALUE = FINER.intValue() + 1;
        private static final int EVENT_FINEST_VALUE = FINEST.intValue() + 1;
        public static final MonitorLevel METRIC = new MonitorLevel("METRIC", 902);
        public static final MonitorLevel EVENT_SEVERE = new MonitorLevel("EVENT", EVENT_SEVERE_VALUE);
        public static final MonitorLevel EVENT_WARNING = new MonitorLevel("EVENT", EVENT_WARNING_VALUE);
        public static final MonitorLevel EVENT_INFO = new MonitorLevel("EVENT", EVENT_INFO_VALUE);
        public static final MonitorLevel EVENT_CONFIG = new MonitorLevel("EVENT", EVENT_CONFIG_VALUE);
        public static final MonitorLevel EVENT_FINE = new MonitorLevel("EVENT", EVENT_FINE_VALUE);
        public static final MonitorLevel EVENT_FINER = new MonitorLevel("EVENT", EVENT_FINER_VALUE);
        public static final MonitorLevel EVENT_FINEST = new MonitorLevel("EVENT", EVENT_FINEST_VALUE);

        private MonitorLevel(String name, int value) {
            super(name, value);
        }

        public static MonitorLevel getEventLevel(int value) {
            if (++value == EVENT_SEVERE_VALUE) {
                return EVENT_SEVERE;
            }
            if (value == EVENT_WARNING_VALUE) {
                return EVENT_WARNING;
            }
            if (value == EVENT_INFO_VALUE) {
                return EVENT_INFO;
            }
            if (value == EVENT_CONFIG_VALUE) {
                return EVENT_CONFIG;
            }
            if (value == EVENT_FINE_VALUE) {
                return EVENT_FINE;
            }
            if (value == EVENT_FINER_VALUE) {
                return EVENT_FINER;
            }
            if (value == EVENT_FINEST_VALUE) {
                return EVENT_FINEST;
            }
            return new MonitorLevel("EVENT", value);
        }

        private Object readResolve() {
            int value = this.intValue();
            if (value == 902) {
                return METRIC;
            }
            if (value == EVENT_SEVERE_VALUE) {
                return EVENT_SEVERE;
            }
            if (value == EVENT_WARNING_VALUE) {
                return EVENT_WARNING;
            }
            if (value == EVENT_INFO_VALUE) {
                return EVENT_INFO;
            }
            if (value == EVENT_CONFIG_VALUE) {
                return EVENT_CONFIG;
            }
            if (value == EVENT_FINE_VALUE) {
                return EVENT_FINE;
            }
            if (value == EVENT_FINER_VALUE) {
                return EVENT_FINER;
            }
            if (value == EVENT_FINEST_VALUE) {
                return EVENT_FINEST;
            }
            return new MonitorLevel("EVENT", value);
        }
    }
}

