/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.util;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Map;

public class NetSimUtil {
    public static SocketChannel setTcpParams(SocketChannel sc, Map<String, String> paramsAsMap) throws IOException, SocketException {
        for (Map.Entry<String, String> params_itr : paramsAsMap.entrySet()) {
            String paramKey = params_itr.getKey();
            String paramValue = params_itr.getValue();
            if ("tcpNoDelay".equals(paramKey)) {
                if (NetSimUtil.isCorrectBoolean(paramValue)) {
                    sc.socket().setTcpNoDelay(Boolean.valueOf(paramValue));
                    continue;
                }
                throw new IllegalArgumentException(paramValue + " is not a boolean.");
            }
            if ("receiveBufferSize".equals(paramKey)) {
                try {
                    sc.socket().setReceiveBufferSize(Integer.parseInt(paramValue));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new NumberFormatException("receiveBufferSize is not valid Integer.");
                }
            }
            if ("reuseAddress".equals(paramKey)) {
                if (NetSimUtil.isCorrectBoolean(paramValue)) {
                    sc.socket().setReuseAddress(Boolean.valueOf(paramValue));
                    continue;
                }
                throw new IllegalArgumentException(paramValue + " is not a boolean.");
            }
            if (!"sendBufferSize".equals(paramKey)) continue;
            try {
                sc.socket().setSendBufferSize(Integer.parseInt(paramValue));
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("sendBufferSize is not valid Integer.");
            }
        }
        return sc;
    }

    private static boolean isCorrectBoolean(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
    }
}

