/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.tests.unitofwork.Contact;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class Person
implements Serializable {
    public String name;
    public Vector contacts;
    public BigDecimal id;
    public BigDecimal luckyNumber;

    public BigDecimal calculateLuckyNumber(DataRecord row, Session session) {
        Number code = (Number)row.get((Object)"ID");
        return new BigDecimal(code.doubleValue() * 2.435);
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        OneToManyMapping oneToMany = new OneToManyMapping();
        descriptor.setJavaClass(Person.class);
        descriptor.setTableName("U_EMP");
        descriptor.setPrimaryKeyFieldName("ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.addDirectMapping("id", "ID");
        descriptor.addDirectMapping("name", "NAME");
        oneToMany.setAttributeName("contacts");
        oneToMany.setReferenceClass(Contact.class);
        oneToMany.addTargetForeignKeyFieldName("EMP_ID", "ID");
        oneToMany.dontUseIndirection();
        descriptor.addMapping((DatabaseMapping)oneToMany);
        TransformationMapping trans = new TransformationMapping();
        trans.setIsReadOnly(true);
        trans.dontUseIndirection();
        trans.setAttributeName("luckyNumber");
        trans.setAttributeTransformation("calculateLuckyNumber");
        descriptor.addMapping((DatabaseMapping)trans);
        return descriptor;
    }

    public static Person example1() {
        Person example = new Person();
        Vector<Contact> contacts = new Vector<Contact>();
        contacts.addElement(Contact.example1(example));
        contacts.addElement(Contact.example2(example));
        example.name = "Dave";
        example.contacts = contacts;
        return example;
    }

    public static Person example2() {
        Person example = new Person();
        Vector<Contact> contacts = new Vector<Contact>();
        contacts.addElement(Contact.example3(example));
        contacts.addElement(Contact.example4(example));
        example.name = "Bob";
        example.contacts = contacts;
        return example;
    }

    public Vector getContacts() {
        return this.contacts;
    }

    public void addContact(Contact newContact) {
        this.contacts.addElement(newContact);
        newContact.person = this;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("U_EMP");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("NAME", String.class, 20);
        definition.addField("CONTACT", BigDecimal.class, 15);
        return definition;
    }
}

