/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.contextlogger;

import java.io.Closeable;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.kv.impl.util.contextlogger.LogContext;

public class ContextLogManager
extends LogManager {
    @Override
    public synchronized Logger getLogger(String name) {
        Logger logger = super.getLogger(name);
        if (logger == null) {
            logger = new ContextLogger(name, null);
            super.addLogger(logger);
        }
        return logger;
    }

    public static boolean isLoggableWithContext(Level recordLevel) {
        LogContext lc = WithLogContext.get();
        if (lc == null) {
            return false;
        }
        int contextLevelValue = lc.getLogLevel();
        return recordLevel.intValue() >= contextLevelValue;
    }

    public static boolean isLoggableWithContext(LogRecord record) {
        return ContextLogManager.isLoggableWithContext(record.getLevel());
    }

    public static class WithLogContext
    implements Closeable {
        private static final ThreadLocal<LogContext> local = new ThreadLocal();

        public WithLogContext(LogContext c) {
            WithLogContext.set(c);
        }

        @Override
        public void close() {
            WithLogContext.unset();
        }

        private static void set(LogContext c) {
            local.set(c);
        }

        private static void unset() {
            local.remove();
        }

        public static LogContext get() {
            return local.get();
        }
    }

    public static class ContextLogger
    extends Logger {
        public ContextLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
        }

        @Override
        public boolean isLoggable(Level level) {
            if (super.isLoggable(level)) {
                return true;
            }
            return ContextLogManager.isLoggableWithContext(level);
        }
    }
}

