/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedGetSystemProperty;
import org.eclipse.persistence.logging.AbstractSessionLog;

public class PrivilegedAccessHelper {
    private static final String TRUE_STRING = "true";
    private static boolean defaultUseDoPrivilegedValue = false;
    private static boolean shouldCheckPrivilegedAccess = true;
    private static boolean shouldUsePrivilegedAccess = false;
    private static final String[] legalProperties = new String[]{"file.separator", "java.io.tmpdir", "java.specification.version", "line.separator", "path.separator", "user.dir", "org.eclipse.persistence.fetchgroupmonitor", "org.eclipse.persistence.querymonitor", "SAP_J2EE_Engine_Version", "eclipselink.persistencexml", "INTERACT_WITH_DB", "eclipselink.logging.file", "eclipselink.logging.level", "eclipselink.archive.factory", "eclipselink.target-server.enforce", "eclipselink.cache.record-stack-on-lock", "eclipselink.weaving.output.path", "eclipselink.weaving.overwrite.existing", "eclipselink.weaving.reflective-introspection", "eclipselink.query.query-by-example.ignore-xtomany", "eclipselink.mapping.onetomany.defer-inserts", "eclipselink.concurrency.manager.waittime", "eclipselink.concurrency.manager.build.object.complete.waittime", "eclipselink.concurrency.manager.maxsleeptime", "eclipselink.concurrency.manager.maxfrequencytodumptinymessage", "eclipselink.concurrency.manager.maxfrequencytodumpmassivemessage", "eclipselink.concurrency.manager.allow.interruptedexception", "eclipselink.concurrency.manager.allow.concurrency.exception", "eclipselink.concurrency.manager.allow.readlockstacktrace", "eclipselink.security.encryptor.use.strong.random.number.generator", "eclipselink.register.run.mbean", "eclipselink.register.dev.mbean", "eclipselink.xml.platform"};
    private static final Set<String> legalPropertiesSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(legalProperties)));
    private static final String[] exemptedProperties = new String[]{"line.separator"};
    private static final Set<String> exemptedPropertiesSet = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(exemptedProperties)));
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();

    public static <T> T callDoPrivileged(PrivilegedCallable<T> task) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return (T)AccessController.doPrivileged(task::call);
        }
        return task.call();
    }

    public static <T> T callDoPrivilegedWithException(PrivilegedExceptionCallable<T> task) throws Exception {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (T)AccessController.doPrivileged(task::call);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        return task.call();
    }

    public static <T> T callDoPrivilegedWithThrowable(PrivilegedExceptionCallable<T> task) throws Throwable {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (T)AccessController.doPrivileged(task::call);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
        return task.call();
    }

    public static void callDoPrivilegedWithException(PrivilegedExceptionConsumer task) throws Exception {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                AccessController.doPrivileged(() -> {
                    task.accept();
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        } else {
            task.accept();
        }
    }

    public static <T, E extends Exception> T callDoPrivilegedWithException(PrivilegedExceptionCallable<T> task, CallableExceptionSupplier<E> exception) throws E {
        try {
            return PrivilegedAccessHelper.callDoPrivilegedWithException(task);
        }
        catch (Exception e) {
            throw exception.get(e);
        }
    }

    public static <T, E extends Throwable> T callDoPrivilegedWithThrowable(PrivilegedExceptionCallable<T> task, CallableThrowableSupplier<E> throwable) throws E {
        try {
            return PrivilegedAccessHelper.callDoPrivilegedWithThrowable(task);
        }
        catch (Throwable e) {
            throw throwable.get(e);
        }
    }

    public static <E extends Exception> void callDoPrivilegedWithException(PrivilegedExceptionConsumer task, CallableExceptionSupplier<E> exception) throws E {
        try {
            PrivilegedAccessHelper.callDoPrivilegedWithException(task);
        }
        catch (Exception e) {
            throw exception.get(e);
        }
    }

    public static void setDefaultUseDoPrivilegedValue(boolean def) {
        defaultUseDoPrivilegedValue = def;
        shouldCheckPrivilegedAccess = true;
    }

    private static <T> Field findDeclaredField(Class<T> javaClass, String fieldName) throws NoSuchFieldException {
        try {
            return javaClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            Class<T> superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            return PrivilegedAccessHelper.findDeclaredField(superclass, fieldName);
        }
    }

    private static <T> Method findMethod(Class<T> javaClass, String methodName, Class<?>[] methodParameterTypes) throws NoSuchMethodException {
        try {
            return javaClass.getDeclaredMethod(methodName, methodParameterTypes);
        }
        catch (NoSuchMethodException ex) {
            Class<T> superclass = javaClass.getSuperclass();
            if (superclass == null) {
                throw ex;
            }
            try {
                return PrivilegedAccessHelper.findMethod(superclass, methodName, methodParameterTypes);
            }
            catch (NoSuchMethodException lastEx) {
                throw ex;
            }
        }
    }

    public static <T> Class<T> getClassForName(String className) throws ClassNotFoundException {
        Class<?> primitive = primitiveClasses.get(className);
        if (primitive != null) {
            return primitive;
        }
        return Class.forName(className);
    }

    public static <T> Class<T> getClassForName(String className, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        Class<?> primitive = primitiveClasses.get(className);
        if (primitive != null) {
            return primitive;
        }
        return Class.forName(className, initialize, loader);
    }

    public static ClassLoader getClassLoaderForClass(Class<?> clazz) {
        return clazz.getClassLoader();
    }

    public static <T> Constructor<T> getConstructorFor(Class<T> javaClass, Class<?>[] args, boolean shouldSetAccessible) throws NoSuchMethodException {
        Constructor<Object> result;
        block5: {
            result = null;
            try {
                result = javaClass.getConstructor(args);
            }
            catch (NoSuchMethodException missing) {
                for (Constructor<?> constructor : javaClass.getConstructors()) {
                    if (constructor.getParameterTypes().length != args.length) continue;
                    boolean found = true;
                    for (int index = 0; index < args.length; ++index) {
                        Class<?> argType;
                        Class<?> parameterType = Helper.getObjectClass(constructor.getParameterTypes()[index]);
                        if (parameterType.isAssignableFrom(argType = Helper.getObjectClass(args[index])) || argType.isAssignableFrom(parameterType)) continue;
                        found = false;
                        break;
                    }
                    if (!found) continue;
                    result = constructor;
                    break;
                }
                if (result != null) break block5;
                throw missing;
            }
        }
        if (shouldSetAccessible && !result.trySetAccessible()) {
            AbstractSessionLog.getLog().log(3, "misc", "set_accessible", (Object)"constructor", (Object)javaClass.getName());
        }
        return result;
    }

    public static ClassLoader getContextClassLoader(Thread thread) {
        return thread.getContextClassLoader();
    }

    public static <T> Constructor<T> getDeclaredConstructorFor(Class<T> javaClass, Class<?>[] args, boolean shouldSetAccessible) throws NoSuchMethodException {
        Constructor<T> result = javaClass.getDeclaredConstructor(args);
        if (shouldSetAccessible && !result.trySetAccessible()) {
            AbstractSessionLog.getLog().log(3, "misc", "set_accessible", (Object)"declared constructor", (Object)javaClass.getName());
        }
        return result;
    }

    public static Field getField(Class<?> javaClass, String fieldName, boolean shouldSetAccessible) throws NoSuchFieldException {
        Field field = PrivilegedAccessHelper.findDeclaredField(javaClass, fieldName);
        if (shouldSetAccessible && !field.trySetAccessible()) {
            AbstractSessionLog.getLog().log(3, "misc", "set_accessible_in", (Object)"field", (Object)fieldName, (Object)javaClass.getName());
        }
        return field;
    }

    public static Field getDeclaredField(Class<?> javaClass, String fieldName, boolean shouldSetAccessible) throws NoSuchFieldException {
        Field field = javaClass.getDeclaredField(fieldName);
        if (shouldSetAccessible && !field.trySetAccessible()) {
            AbstractSessionLog.getLog().log(3, "misc", "set_accessible_in", (Object)"declared field", (Object)fieldName, (Object)javaClass.getName());
        }
        return field;
    }

    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    public static Field[] getFields(Class<?> clazz) {
        return clazz.getFields();
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?>[] methodParameterTypes) throws NoSuchMethodException {
        return clazz.getDeclaredMethod(methodName, methodParameterTypes);
    }

    public static Method getMethod(Class<?> javaClass, String methodName, Class<?>[] methodParameterTypes, boolean shouldSetAccessible) throws NoSuchMethodException {
        Method method = PrivilegedAccessHelper.findMethod(javaClass, methodName, methodParameterTypes);
        if (shouldSetAccessible && !method.trySetAccessible()) {
            AbstractSessionLog.getLog().log(3, "misc", "set_accessible_in", (Object)"method", (Object)methodName, (Object)javaClass.getName());
        }
        return method;
    }

    public static Method getPublicMethod(Class<?> javaClass, String methodName, Class<?>[] methodParameterTypes, boolean shouldSetAccessible) throws NoSuchMethodException {
        Method method = javaClass.getMethod(methodName, methodParameterTypes);
        if (shouldSetAccessible && !method.trySetAccessible()) {
            AbstractSessionLog.getLog().log(3, "misc", "set_accessible_in", (Object)"public method", (Object)methodName, (Object)javaClass.getName());
        }
        return method;
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static <T> Class<T> getFieldType(Field field) {
        return field.getType();
    }

    private static boolean isIllegalProperty(String key) {
        return key == null || !legalPropertiesSet.contains(key) && !key.startsWith("eclipselink.") && !key.startsWith("jakarta.persistence.") && !key.startsWith("org.eclipse.persistence.") && !key.startsWith("persistence.") && !key.startsWith("javax.xml.") && !key.startsWith("jakarta.xml.");
    }

    private static boolean isExemptedProperty(String key) {
        return key != null && exemptedPropertiesSet.contains(key);
    }

    public static String getSystemProperty(String key) {
        if (PrivilegedAccessHelper.isIllegalProperty(key)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unexpect_argument", new Object[]{key}));
        }
        if (PrivilegedAccessHelper.isExemptedProperty(key) || PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedGetSystemProperty(key));
        }
        return System.getProperty(key);
    }

    public static String getSystemProperty(String key, String def) {
        if (PrivilegedAccessHelper.isIllegalProperty(key)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("unexpect_argument", new Object[]{key}));
        }
        if (PrivilegedAccessHelper.isExemptedProperty(key) || PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            return AccessController.doPrivileged(new PrivilegedGetSystemProperty(key, def));
        }
        return System.getProperty(key, def);
    }

    public static boolean getSystemPropertyBoolean(String key, boolean def) {
        return TRUE_STRING.equalsIgnoreCase(PrivilegedAccessHelper.getSystemProperty(key, def ? TRUE_STRING : ""));
    }

    public static String getLineSeparator() {
        return PrivilegedAccessHelper.getSystemProperty("line.separator");
    }

    public static Class<?>[] getMethodParameterTypes(Method method) {
        return method.getParameterTypes();
    }

    public static <T> Class<T> getMethodReturnType(Method method) {
        return method.getReturnType();
    }

    public static Method[] getMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    public static <T> T getValueFromField(Field field, Object object) throws IllegalAccessException {
        return (T)field.get(object);
    }

    public static <T> T invokeConstructor(Constructor<T> constructor, Object[] args) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return constructor.newInstance(args);
    }

    public static <T> T invokeMethod(Method method, Object object) throws IllegalAccessException, InvocationTargetException {
        return PrivilegedAccessHelper.invokeMethod(method, object, null);
    }

    public static <T> T invokeMethod(Method method, Object object, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        if (!method.isAccessible() && !method.trySetAccessible()) {
            AbstractSessionLog.getLog().log(3, "misc", "set_accessible_in", (Object)"method", (Object)method.getName(), (Object)(method.getDeclaringClass().getName() + " for invokation"));
        }
        return (T)method.invoke(object, parameters);
    }

    public static <T> T newInstanceFromClass(Class<T> clazz) throws IllegalAccessException, InstantiationException {
        return clazz.newInstance();
    }

    public static void setValueInField(Field field, Object object, Object value) throws IllegalAccessException {
        field.set(object, value);
    }

    public static boolean shouldUsePrivilegedAccess() {
        if (shouldCheckPrivilegedAccess) {
            String usePrivileged;
            shouldUsePrivilegedAccess = System.getSecurityManager() != null ? ((usePrivileged = AccessController.doPrivileged(new PrivilegedGetSystemProperty("eclipselink.security.usedoprivileged"))) == null ? defaultUseDoPrivilegedValue : usePrivileged.equalsIgnoreCase(TRUE_STRING)) : false;
            shouldCheckPrivilegedAccess = false;
        }
        return shouldUsePrivilegedAccess;
    }

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("void", Void.TYPE);
        primitiveClasses.put("short", Short.TYPE);
    }

    @FunctionalInterface
    public static interface PrivilegedCallable<T> {
        public T call();
    }

    @FunctionalInterface
    public static interface PrivilegedExceptionCallable<T> {
        public T call() throws Exception;
    }

    @FunctionalInterface
    public static interface PrivilegedExceptionConsumer {
        public void accept() throws Exception;
    }

    @FunctionalInterface
    public static interface CallableExceptionSupplier<E extends Exception> {
        public E get(Exception var1);
    }

    @FunctionalInterface
    public static interface CallableThrowableSupplier<T extends Throwable> {
        public T get(Throwable var1);
    }
}

