/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.framework.jpa.server;

import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.Remote;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.persistence.testing.framework.jpa.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.jpa.server.JEEPlatform;
import org.eclipse.persistence.testing.framework.jpa.server.TestRunner;

@Stateless(name="GenericTestRunner")
@Remote(value={TestRunner.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class GenericTestRunner
implements TestRunner {
    @Resource
    private SessionContext ctx;

    @Override
    public Throwable runTest(String className, String test, Properties props) {
        TestCase testInstance = null;
        try {
            Class<?> testClass = this.getClass().getClassLoader().loadClass(className);
            Constructor<?> c = testClass.getConstructor(String.class);
            testInstance = (TestCase)c.newInstance(test);
        }
        catch (ReflectiveOperationException e) {
            throw new EJBException((Exception)e);
        }
        if (props != null) {
            System.getProperties().putAll((Map<?, ?>)props);
        }
        Throwable result = null;
        try {
            if (testInstance instanceof JUnitTestCase) {
                JUnitTestCase jpaTest = (JUnitTestCase)testInstance;
                String puName = jpaTest.getPuName();
                if (puName != null && !"default".equals(puName)) {
                    JEEPlatform.entityManager = (EntityManager)this.lookup("persistence/" + puName + "/entity-manager");
                    JEEPlatform.entityManagerFactory = (EntityManagerFactory)this.lookup("persistence/" + puName + "/factory");
                } else {
                    JEEPlatform.entityManager = this.getEntityManager();
                    JEEPlatform.entityManagerFactory = this.getEntityManagerFactory();
                }
                JEEPlatform.ejbLookup = this.getEjbLookup();
                jpaTest.runBareServer();
            } else {
                testInstance.runBare();
            }
        }
        catch (Throwable t) {
            result = t;
        }
        return result;
    }

    protected EntityManager getEntityManager() {
        return null;
    }

    protected EntityManagerFactory getEntityManagerFactory() {
        return null;
    }

    protected boolean getEjbLookup() {
        return true;
    }

    private <T> T lookup(String jndiName) {
        return (T)this.ctx.lookup(jndiName);
    }
}

