/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.transparentindirection;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectMap;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.transparentindirection.AbstractOrder;
import org.eclipse.persistence.testing.models.transparentindirection.MappedOrder;
import org.eclipse.persistence.testing.models.transparentindirection.Order;
import org.eclipse.persistence.testing.models.transparentindirection.SetOrder;

public class NullDelegateInValueHolderTest
extends TestCase {
    protected Class<?> indirectCollectionClass;
    protected AbstractOrder testOrder;

    public NullDelegateInValueHolderTest(Class<?> indirectCollectionClass) {
        this.indirectCollectionClass = indirectCollectionClass;
        this.setDescription("NullDelegateInValueHolderTest: " + Helper.getShortClassName(this.indirectCollectionClass));
    }

    public void setup() {
        String customerName = "ACME, Inc.";
        if (this.indirectCollectionClass.equals(IndirectList.class)) {
            this.testOrder = new Order(customerName);
        } else if (this.indirectCollectionClass.equals(IndirectMap.class)) {
            this.testOrder = new MappedOrder(customerName);
        } else if (this.indirectCollectionClass.equals(IndirectSet.class)) {
            this.testOrder = new SetOrder(customerName);
        }
        ClassDescriptor descriptor = this.getSession().getDescriptor((Object)this.testOrder);
        ForeignReferenceMapping mapping = (ForeignReferenceMapping)descriptor.getMappingForAttributeName("salesReps");
        IndirectionPolicy policy = mapping.getIndirectionPolicy();
        mapping.setAttributeValueInObject((Object)this.testOrder, policy.buildIndirectObject((ValueHolderInterface)new ValueHolder()));
    }

    public void test() {
        int numberOfObjects = -1;
        try {
            numberOfObjects = this.testOrder.getNumberOfSalesReps();
        }
        catch (Exception e) {
            throw new TestErrorException("Error retrieving number of sales reps from order " + this.testOrder, (Throwable)e);
        }
        if (numberOfObjects != 0) {
            this.throwError("Number of sales reps != 0 :" + numberOfObjects);
        }
    }
}

