/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.documentpreservation;

import java.util.WeakHashMap;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderCacheEntry;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.documentpreservation.RelativePositionOrderingPolicy;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.w3c.dom.Node;

public class XMLBinderPolicy
extends DocumentPreservationPolicy {
    private WeakHashMap nodesToObjects = new WeakHashMap();
    private WeakHashMap objectsToNodes = new WeakHashMap();

    public XMLBinderPolicy() {
        this.setNodeOrderingPolicy(new RelativePositionOrderingPolicy());
    }

    public void addObjectToCache(Object obj, Node node) {
        this.addObjectToCache(obj, node, null);
    }

    public void addObjectToCache(Object obj, Node node, XMLMapping selfRecordMapping) {
        this.objectsToNodes.put(obj, node);
        if (selfRecordMapping != null) {
            XMLBinderCacheEntry entry = (XMLBinderCacheEntry)this.nodesToObjects.get(node);
            if (entry != null) {
                entry.addSelfMappingObject(selfRecordMapping, obj);
            }
        } else {
            XMLBinderCacheEntry entry = new XMLBinderCacheEntry(obj);
            this.nodesToObjects.put(node, entry);
        }
    }

    public Node getNodeForObject(Object obj) {
        return (Node)this.objectsToNodes.get(obj);
    }

    public Object getObjectForNode(Node node) {
        return this.getObjectForNode(node, null);
    }

    public Object getObjectForNode(Node node, XMLMapping selfRecordMapping) {
        XMLBinderCacheEntry entry = (XMLBinderCacheEntry)this.nodesToObjects.get(node);
        if (entry != null) {
            if (selfRecordMapping != null) {
                return entry.getSelfMappingObject(selfRecordMapping);
            }
            return entry.getRootObject();
        }
        return null;
    }

    public boolean shouldPreserveDocument() {
        return true;
    }
}

