/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class BasicMapAccessor
extends BasicCollectionAccessor {
    private ColumnMetadata m_keyColumn;
    private String m_keyConverter;
    private String m_valueConverter;

    public BasicMapAccessor() {
        super("<basic-map>");
    }

    public BasicMapAccessor(MetadataAnnotation basicMap, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(basicMap, accessibleObject, classAccessor);
        MetadataAnnotation valueConvert;
        this.m_keyColumn = new ColumnMetadata((MetadataAnnotation)basicMap.getAttribute("keyColumn"), accessibleObject, this.getAttributeName());
        MetadataAnnotation keyConvert = (MetadataAnnotation)basicMap.getAttribute("keyConverter");
        if (keyConvert != null) {
            this.m_keyConverter = (String)keyConvert.getAttribute("value");
        }
        if ((valueConvert = (MetadataAnnotation)basicMap.getAttribute("valueConverter")) != null) {
            this.m_valueConverter = (String)valueConvert.getAttribute("value");
        }
        this.setValueColumn(new ColumnMetadata((MetadataAnnotation)basicMap.getAttribute("valueColumn"), accessibleObject, this.getAttributeName()));
        this.setFetch((String)basicMap.getAttribute("fetch"));
    }

    protected ColumnMetadata getColumn(String loggingCtx) {
        if (loggingCtx.equals("metadata_default_value_column")) {
            return super.getColumn(loggingCtx);
        }
        return this.m_keyColumn == null ? super.getColumn(loggingCtx) : this.m_keyColumn;
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_keyColumn != null && this.m_keyColumn.getTable() != null && !this.m_keyColumn.getTable().equals("")) {
            return this.m_keyColumn.getTable();
        }
        return super.getDefaultCollectionTableName();
    }

    public ColumnMetadata getKeyColumn() {
        return this.m_keyColumn;
    }

    public String getKeyConverter() {
        return this.m_keyConverter;
    }

    public MetadataClass getReferenceClass() {
        return this.getReferenceClassFromGeneric();
    }

    public String getValueConverter() {
        return this.m_valueConverter;
    }

    protected boolean hasConvert(boolean isForMapKey) {
        return true;
    }

    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObject(this.m_keyColumn, accessibleObject);
    }

    public boolean isBasicMap() {
        return true;
    }

    public void process() {
        if (!this.isValidDirectMapType()) {
            throw ValidationException.invalidTypeForBasicMapAttribute((String)this.getAttributeName(), (Object)this.getRawClass(), (Object)this.getJavaClass());
        }
        this.processDirectMapMapping();
    }

    public void setKeyColumn(ColumnMetadata keyColumn) {
        this.m_keyColumn = keyColumn;
    }

    public void setKeyConverter(String keyConverter) {
        this.m_keyConverter = keyConverter;
    }

    public void setValueConverter(String valueConverter) {
        this.m_valueConverter = valueConverter;
    }
}

