/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.ULocale;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;

public class DateFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public final java.text.DateFormat dateFormat;
    public static final int ERA_FIELD = 0;
    public static final int YEAR_FIELD = 1;
    public static final int MONTH_FIELD = 2;
    public static final int DATE_FIELD = 3;
    public static final int HOUR_OF_DAY1_FIELD = 4;
    public static final int HOUR_OF_DAY0_FIELD = 5;
    public static final int MINUTE_FIELD = 6;
    public static final int SECOND_FIELD = 7;
    public static final int FRACTIONAL_SECOND_FIELD = 8;
    public static final int MILLISECOND_FIELD = 8;
    public static final int DAY_OF_WEEK_FIELD = 9;
    public static final int DAY_OF_YEAR_FIELD = 10;
    public static final int DAY_OF_WEEK_IN_MONTH_FIELD = 11;
    public static final int WEEK_OF_YEAR_FIELD = 12;
    public static final int WEEK_OF_MONTH_FIELD = 13;
    public static final int AM_PM_FIELD = 14;
    public static final int HOUR1_FIELD = 15;
    public static final int HOUR0_FIELD = 16;
    public static final int TIMEZONE_FIELD = 17;
    public static final int FULL = 0;
    public static final int LONG = 1;
    public static final int MEDIUM = 2;
    public static final int SHORT = 3;
    public static final int DEFAULT = 2;

    public DateFormat(java.text.DateFormat delegate) {
        this.dateFormat = delegate;
    }

    protected DateFormat() {
        this.dateFormat = java.text.DateFormat.getInstance();
    }

    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (obj instanceof Calendar) {
            return this.format((Calendar)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Date) {
            return this.format((Date)obj, toAppendTo, fieldPosition);
        }
        if (obj instanceof Number) {
            return this.format(new Date(((Number)obj).longValue()), toAppendTo, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Date");
    }

    public StringBuffer format(Calendar cal, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.format(cal.getTime(), toAppendTo, fieldPosition);
    }

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        return this.dateFormat.format(date, toAppendTo, fieldPosition);
    }

    public final String format(Date date) {
        return this.dateFormat.format(date);
    }

    public Date parse(String text) throws ParseException {
        return this.dateFormat.parse(text);
    }

    public void parse(String text, Calendar cal, ParsePosition pos) {
        Date result = this.dateFormat.parse(text, pos);
        cal.setTime(result);
    }

    public Date parse(String text, ParsePosition pos) {
        return this.dateFormat.parse(text, pos);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public static final DateFormat getTimeInstance() {
        return new DateFormat(java.text.DateFormat.getTimeInstance());
    }

    public static final DateFormat getTimeInstance(int style) {
        return new DateFormat(java.text.DateFormat.getTimeInstance(style));
    }

    public static final DateFormat getTimeInstance(int style, Locale aLocale) {
        return new DateFormat(java.text.DateFormat.getTimeInstance(style, aLocale));
    }

    public static final DateFormat getTimeInstance(int style, ULocale aLocale) {
        return new DateFormat(java.text.DateFormat.getTimeInstance(style, aLocale.toLocale()));
    }

    public static final DateFormat getDateInstance() {
        return new DateFormat(java.text.DateFormat.getDateInstance());
    }

    public static final DateFormat getDateInstance(int style) {
        return new DateFormat(java.text.DateFormat.getDateInstance(style));
    }

    public static final DateFormat getDateInstance(int style, Locale aLocale) {
        return new DateFormat(java.text.DateFormat.getDateInstance(style, aLocale));
    }

    public static final DateFormat getDateInstance(int style, ULocale aLocale) {
        return new DateFormat(java.text.DateFormat.getDateInstance(style, aLocale.toLocale()));
    }

    public static final DateFormat getDateTimeInstance() {
        return new DateFormat(java.text.DateFormat.getDateTimeInstance());
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return new DateFormat(java.text.DateFormat.getDateTimeInstance(dateStyle, timeStyle));
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle, Locale aLocale) {
        return new DateFormat(java.text.DateFormat.getDateTimeInstance(dateStyle, timeStyle, aLocale));
    }

    public static final DateFormat getDateTimeInstance(int dateStyle, int timeStyle, ULocale aLocale) {
        return new DateFormat(java.text.DateFormat.getDateTimeInstance(dateStyle, timeStyle, aLocale.toLocale()));
    }

    public static final DateFormat getInstance() {
        return new DateFormat(java.text.DateFormat.getInstance());
    }

    public static Locale[] getAvailableLocales() {
        return java.text.DateFormat.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        Locale[] locales = java.text.DateFormat.getAvailableLocales();
        ULocale[] ulocales = new ULocale[locales.length];
        int i = 0;
        while (i < locales.length) {
            ulocales[i] = ULocale.forLocale(locales[i]);
            ++i;
        }
        return ulocales;
    }

    public void setCalendar(Calendar newCalendar) {
        this.dateFormat.setCalendar(newCalendar.calendar);
    }

    public Calendar getCalendar() {
        return new Calendar(this.dateFormat.getCalendar());
    }

    public void setNumberFormat(NumberFormat newNumberFormat) {
        this.dateFormat.setNumberFormat(newNumberFormat.numberFormat);
    }

    public NumberFormat getNumberFormat() {
        return new NumberFormat(this.dateFormat.getNumberFormat());
    }

    public void setTimeZone(TimeZone zone) {
        this.dateFormat.setTimeZone(zone.timeZone);
    }

    public TimeZone getTimeZone() {
        return new TimeZone(this.dateFormat.getTimeZone());
    }

    public void setLenient(boolean lenient) {
        this.dateFormat.setLenient(lenient);
    }

    public boolean isLenient() {
        return this.dateFormat.isLenient();
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle, ULocale locale) {
        DateFormat df = DateFormat.getDateInstance(dateStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle, Locale locale) {
        DateFormat df = DateFormat.getTimeInstance(timeStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle, ULocale locale) {
        DateFormat df = DateFormat.getTimeInstance(timeStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle, Locale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle, ULocale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getInstance(Calendar cal, Locale locale) {
        return DateFormat.getDateTimeInstance(cal, 2, 3, locale);
    }

    public static final DateFormat getInstance(Calendar cal, ULocale locale) {
        return DateFormat.getDateTimeInstance(cal, 2, 3, locale);
    }

    public static final DateFormat getInstance(Calendar cal) {
        return DateFormat.getDateTimeInstance(cal, 2, 3, ULocale.getDefault());
    }

    public static final DateFormat getDateInstance(Calendar cal, int dateStyle) {
        DateFormat df = DateFormat.getDateInstance(dateStyle);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getTimeInstance(Calendar cal, int timeStyle) {
        DateFormat df = DateFormat.getTimeInstance(timeStyle);
        df.setCalendar(cal);
        return df;
    }

    public static final DateFormat getDateTimeInstance(Calendar cal, int dateStyle, int timeStyle) {
        DateFormat df = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
        df.setCalendar(cal);
        return df;
    }

    public String toString() {
        return this.dateFormat.toString();
    }

    public Object clone() {
        return new DateFormat((java.text.DateFormat)this.dateFormat.clone());
    }

    public boolean equals(Object arg0) {
        try {
            return this.dateFormat.equals(((DateFormat)arg0).dateFormat);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.dateFormat.hashCode();
    }
}

