/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ITableItemAdapter;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends Item {
    private final TableItemAdapter tableItemAdapter;
    final Table parent;
    boolean cached;
    int index;
    private Data[] data;
    private boolean checked;
    private boolean grayed;
    private Color background;
    private Color foreground;
    private Font font;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public TableItem(Table parent, int style) {
        this(parent, style, TableItem.checkNull(parent).getItemCount());
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, true);
    }

    TableItem(Table parent, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        this.index = index;
        this.tableItemAdapter = new TableItemAdapter();
        if (create) {
            this.parent.createItem(this, index);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) return this.tableItemAdapter;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) return this.tableItemAdapter;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.swt.internal.widgets.ITableItemAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter != clazz3) return super.getAdapter(adapter);
        return this.tableItemAdapter;
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public void setText(String text) {
        this.checkWidget();
        this.setText(0, text);
    }

    public void setText(int index, String text) {
        this.checkWidget();
        if (text == null) {
            SWT.error(4);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!text.equals(this.data[index].text)) {
                this.data[index].text = text;
                this.markCached();
                if (this.parent.getColumnCount() == 0) {
                    this.parent.updateScrollBars();
                }
                this.parent.redraw();
            }
        }
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            SWT.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public String getText() {
        this.checkWidget();
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        String result = "";
        if (this.data != null && index >= 0 && index < this.data.length && this.data[index] != null) {
            result = this.data[index].text;
        }
        return result;
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!TableItem.equals(this.data[index].image, image)) {
                this.parent.updateColumnImageCount(index, this.data[index].image, image);
                this.data[index].image = image;
                this.parent.updateItemImageSize(image);
                this.markCached();
                if (this.parent.getColumnCount() == 0) {
                    this.parent.updateScrollBars();
                }
                this.parent.redraw();
            }
        }
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            if (images[i] != null && images[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public Image getImage() {
        this.checkWidget();
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        return this.getImageInternal(index);
    }

    Image getImageInternal(int index) {
        Image result = null;
        if (this.data != null && index >= 0 && index < this.data.length && this.data[index] != null) {
            result = this.data[index].image;
        }
        return result;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (!TableItem.equals(this.background, color)) {
            this.background = color;
            this.markCached();
            this.parent.redraw();
        }
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        Color result = this.background == null ? this.parent.getBackground() : this.background;
        return result;
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!TableItem.equals(this.data[index].background, color)) {
                this.data[index].background = color;
                this.markCached();
                this.parent.redraw();
            }
        }
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        Color result = this.getBackground();
        if (this.data != null && index >= 0 && index < this.data.length && this.data[index] != null && this.data[index].background != null) {
            result = this.data[index].background;
        }
        return result;
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if (!TableItem.equals(this.foreground, color)) {
            this.foreground = color;
            this.markCached();
            this.parent.redraw();
        }
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        Color result = this.foreground == null ? this.parent.getForeground() : this.foreground;
        return result;
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!TableItem.equals(this.data[index].foreground, color)) {
                this.data[index].foreground = color;
                this.markCached();
                this.parent.redraw();
            }
        }
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        Color result = this.getForeground();
        if (this.data != null && index >= 0 && index < this.data.length && this.data[index] != null && this.data[index].foreground != null) {
            result = this.data[index].foreground;
        }
        return result;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if (!TableItem.equals(this.font, font)) {
            this.font = font;
            this.markCached();
            if (this.parent.getColumnCount() == 0) {
                this.parent.updateScrollBars();
            }
            this.parent.redraw();
        }
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        Font result = this.font == null ? this.parent.getFont() : this.font;
        return result;
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index >= 0 && index < count) {
            this.ensureData(index, count);
            if (!TableItem.equals(font, this.data[index].font)) {
                this.data[index].font = font;
                this.markCached();
                this.parent.redraw();
            }
        }
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        Font result = this.getFont();
        if (this.data != null && index >= 0 && index < this.data.length && this.data[index] != null && this.data[index].font != null) {
            result = this.data[index].font;
        }
        return result;
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) != 0) {
            this.checked = checked;
        }
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        boolean result = false;
        if ((this.parent.style & 0x20) != 0) {
            result = this.checked;
        }
        return result;
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) != 0) {
            this.grayed = grayed;
        }
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        boolean result = false;
        if ((this.parent.style & 0x20) != 0) {
            result = this.grayed;
        }
        return result;
    }

    public Rectangle getBounds() {
        return this.getBounds(0);
    }

    public Rectangle getBounds(int index) {
        Rectangle result;
        int columnCount;
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        if ((columnCount = this.parent.getColumnCount()) > 0 && (index < 0 || index >= columnCount)) {
            result = new Rectangle(0, 0, 0, 0);
        } else {
            Rectangle textBounds = this.getTextBounds(index);
            int left = this.getLeft(index);
            int itemIndex = this.parent.indexOf(this);
            int top = this.getTop(itemIndex);
            int width = 0;
            if (index == 0 && columnCount == 0) {
                Rectangle imageBounds = this.getImageBounds(index);
                int spacing = this.getSpacing(index);
                int paddingWidth = this.parent.getCellPadding().width;
                width = imageBounds.width + spacing + textBounds.width + paddingWidth;
            } else if (index >= 0 && index < columnCount) {
                width = this.parent.getColumn(index).getWidth() - this.getCheckWidth(index);
            }
            int height = this.getHeight(index);
            result = new Rectangle(left, top, width, height);
        }
        return result;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        int itemIndex = this.parent.indexOf(this);
        Rectangle cellPadding = this.parent.getCellPadding();
        int left = this.getLeft(index) + cellPadding.x;
        int top = this.getTop(itemIndex);
        int width = this.getImageWidth(index);
        int height = this.getHeight(index);
        return new Rectangle(left, top, width, height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this, this.parent.indexOf(this))) {
            this.error(24);
        }
        return 0;
    }

    public Rectangle getTextBounds(int index) {
        int imageWidth;
        this.checkWidget();
        int itemIndex = this.parent.indexOf(this);
        if (!this.parent.checkData(this, itemIndex)) {
            this.error(24);
        }
        int left = 0;
        int top = 0;
        int width = 0;
        Rectangle cellPadding = this.parent.getCellPadding();
        if (index == 0 && this.parent.getColumnCount() == 0) {
            imageWidth = 0;
            int spacing = 0;
            if (this.parent.hasColumnImages(0)) {
                imageWidth = this.parent.getItemImageSize().x;
                spacing = this.getSpacing(0);
            }
            left = this.getLeft(0) + cellPadding.x + imageWidth + spacing;
            top = this.getTop(itemIndex);
            Font font = this.getFont();
            width = Graphics.stringExtent((Font)font, (String)this.getText((int)0)).x;
        } else if (itemIndex != -1 && index < this.parent.getColumnCount()) {
            imageWidth = 0;
            if (this.parent.hasColumnImages(index)) {
                imageWidth = this.parent.getItemImageSize().x;
            }
            int spacing = this.getSpacing(index);
            left = this.getLeft(index) + cellPadding.x + imageWidth + spacing;
            top = this.getTop(itemIndex);
            width = this.getColumnWidth(index) - cellPadding.width - imageWidth - spacing;
            if (width < 0) {
                width = 0;
            }
        }
        int height = this.getHeight(index);
        return new Rectangle(left, top, width, height);
    }

    private int getColumnWidth(int index) {
        TableColumn column = this.parent.getColumn(index);
        return column.getWidth() - this.getCheckWidth(index);
    }

    private int getLeft(int index) {
        int result = 0;
        int columnCount = this.parent.getColumnCount();
        if (index == 0 && columnCount == 0) {
            result = this.getCheckWidth(index) - this.parent.leftOffset;
        } else if (index >= 0 && index < columnCount) {
            int columnLeft = this.parent.getColumn(index).getLeft();
            result = this.getCheckWidth(index) + columnLeft - this.parent.leftOffset;
        }
        return result;
    }

    private int getTop(int itemIndex) {
        int relativeItemIndex = itemIndex - this.parent.getTopIndex();
        int headerHeight = this.parent.getHeaderHeight();
        int itemHeight = this.parent.getItemHeight();
        return headerHeight + relativeItemIndex * itemHeight;
    }

    private int getHeight(int index) {
        boolean columnInRange;
        int result = 0;
        int columnCount = this.parent.getColumnCount();
        boolean singleColumn = index == 0 && columnCount == 0;
        boolean bl = columnInRange = index >= 0 && index < columnCount;
        if (singleColumn || columnInRange) {
            result = this.parent.getItemHeight();
        }
        return result;
    }

    final int getPackWidth(int index) {
        return this.getImageWidth(index) + this.getSpacing(index) + this.getTextWidth(index) + this.parent.getCellPadding().width;
    }

    final int getCheckWidth(int index) {
        return this.parent.getCheckSize((int)index).x;
    }

    private int getImageWidth(int index) {
        int result = 0;
        Image image = this.getImage(index);
        if (image != null) {
            result = this.parent.getItemImageSize().x;
        }
        return result;
    }

    private int getTextWidth(int index) {
        int result = 0;
        String text = this.getText(index);
        if (text.length() > 0) {
            result = Graphics.stringExtent((Font)this.parent.getFont(), (String)text).x;
        }
        return result;
    }

    private int getSpacing(int index) {
        int result = 0;
        if (this.parent.hasColumnImages(index)) {
            result = this.parent.getCellSpacing();
        }
        return result;
    }

    final void shiftData(int index) {
        if (this.data != null && this.data.length > index && this.parent.getColumnCount() > 1) {
            Data[] newData = new Data[this.data.length + 1];
            System.arraycopy(this.data, 0, newData, 0, index);
            int offSet = this.data.length - index;
            System.arraycopy(this.data, index, newData, index + 1, offSet);
            this.data = newData;
        }
    }

    final void removeData(int index) {
        if (this.data != null && this.data.length > index && this.parent.getColumnCount() > 1) {
            Data[] newData = new Data[this.data.length - 1];
            System.arraycopy(this.data, 0, newData, 0, index);
            int offSet = this.data.length - index - 1;
            System.arraycopy(this.data, index + 1, newData, index, offSet);
            this.data = newData;
        }
    }

    final void clear() {
        this.data = null;
        this.checked = false;
        this.grayed = false;
        this.parent.updateScrollBars();
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
            this.parent.redraw();
        }
    }

    void releaseParent() {
        this.parent.destroyItem(this, this.parent.indexOf(this));
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    private void markCached() {
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    private void ensureData(int index, int columnCount) {
        if (this.data == null) {
            this.data = new Data[columnCount];
        } else if (this.data.length < columnCount) {
            Data[] newData = new Data[columnCount];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
        }
        if (this.data[index] == null) {
            this.data[index] = new Data();
        }
    }

    private static boolean equals(Object object1, Object object2) {
        boolean result = object1 == object2 ? true : (object1 == null ? false : object1.equals(object2));
        return result;
    }

    private static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    private static final class Data {
        String text = "";
        Image image;
        Font font;
        Color background;
        Color foreground;

        private Data() {
        }
    }

    private final class TableItemAdapter
    implements ITableItemAdapter {
        private TableItemAdapter() {
        }

        public Color getUserBackground() {
            return TableItem.this.background;
        }

        public Color getUserForeground() {
            return TableItem.this.foreground;
        }

        public Font getUserFont() {
            return TableItem.this.font;
        }

        public Color[] getCellBackgrounds() {
            int columnCount = Math.max(1, TableItem.this.getParent().getColumnCount());
            Color[] result = new Color[columnCount];
            if (TableItem.this.data != null) {
                int i = 0;
                while (i < TableItem.this.data.length) {
                    if (TableItem.this.data[i] != null) {
                        result[i] = ((TableItem)TableItem.this).data[i].background;
                    }
                    ++i;
                }
            }
            return result;
        }

        public Color[] getCellForegrounds() {
            int columnCount = Math.max(1, TableItem.this.getParent().getColumnCount());
            Color[] result = new Color[columnCount];
            if (TableItem.this.data != null) {
                int i = 0;
                while (i < TableItem.this.data.length) {
                    if (TableItem.this.data[i] != null) {
                        result[i] = ((TableItem)TableItem.this).data[i].foreground;
                    }
                    ++i;
                }
            }
            return result;
        }

        public Font[] getCellFonts() {
            int columnCount = Math.max(1, TableItem.this.getParent().getColumnCount());
            Font[] result = new Font[columnCount];
            if (TableItem.this.data != null) {
                int i = 0;
                while (i < TableItem.this.data.length) {
                    if (TableItem.this.data[i] != null) {
                        result[i] = ((TableItem)TableItem.this).data[i].font;
                    }
                    ++i;
                }
            }
            return result;
        }

        public boolean isParentDisposed() {
            return TableItem.this.parent.isDisposed();
        }
    }
}

