/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.AdapterFactory;
import org.eclipse.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterException;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rwt.internal.util.ClassInstantiationException;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.lifecycle.ILifeCycleAdapter;
import org.eclipse.rwt.lifecycle.IWidgetLifeCycleAdapter;
import org.eclipse.swt.internal.widgets.displaykit.DisplayLCAFacade;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public final class LifeCycleAdapterFactory
implements AdapterFactory {
    private static final Class[] ADAPTER_LIST;
    private final Object displayAdapterLock = new Object();
    private final Object widgetAdaptersLock = new Object();
    private IDisplayLifeCycleAdapter displayAdapter;
    private final Map widgetAdapters = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.ILifeCycleAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        ADAPTER_LIST = classArray;
    }

    public Object getAdapter(Object adaptable, Class adapter) {
        ILifeCycleAdapter result = null;
        if (LifeCycleAdapterFactory.isDisplayLCA(adaptable, adapter)) {
            result = this.getDisplayLCA();
        } else if (LifeCycleAdapterFactory.isWidgetLCA(adaptable, adapter)) {
            result = this.getWidgetLCA(adaptable.getClass());
        }
        return result;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private static boolean isDisplayLCA(Object adaptable, Class adapter) {
        if (adaptable instanceof Display) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.ILifeCycleAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ILifeCycleAdapter getDisplayLCA() {
        Object object = this.displayAdapterLock;
        synchronized (object) {
            if (this.displayAdapter == null) {
                this.displayAdapter = DisplayLCAFacade.getDisplayLCA();
            }
            return this.displayAdapter;
        }
    }

    private static boolean isWidgetLCA(Object adaptable, Class adapter) {
        if (adaptable instanceof Widget) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.rwt.lifecycle.ILifeCycleAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized ILifeCycleAdapter getWidgetLCA(Class clazz) {
        ILifeCycleAdapter result;
        Object object = this.widgetAdaptersLock;
        synchronized (object) {
            result = (ILifeCycleAdapter)this.widgetAdapters.get(clazz);
            if (result == null) {
                IWidgetLifeCycleAdapter adapter = null;
                Class superClass = clazz;
                while (true) {
                    Class<?> clazz2;
                    if ((clazz2 = class$1) == null) {
                        try {
                            clazz2 = Class.forName("java.lang.Object");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz2.equals(superClass) || adapter != null) {
                        this.widgetAdapters.put(clazz, adapter);
                        result = adapter;
                        break;
                    }
                    adapter = LifeCycleAdapterFactory.loadWidgetLCA(superClass);
                    if (adapter != null) continue;
                    superClass = superClass.getSuperclass();
                }
            }
        }
        if (result == null) {
            String msg = "Failed to obtain life cycle adapter for: " + clazz.getName();
            throw new LifeCycleAdapterException(msg);
        }
        return result;
    }

    private static IWidgetLifeCycleAdapter loadWidgetLCA(Class clazz) {
        IWidgetLifeCycleAdapter result = null;
        String className = LifeCycleAdapterUtil.getSimpleClassName(clazz);
        String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(clazz);
        int i = 0;
        while (result == null && i < variants.length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(variants[i]);
            buffer.append(".");
            buffer.append(className);
            buffer.append("LCA");
            String classToLoad = buffer.toString();
            ClassLoader loader = clazz.getClassLoader();
            try {
                result = (IWidgetLifeCycleAdapter)ClassUtil.newInstance(loader, classToLoad);
            }
            catch (ClassInstantiationException classInstantiationException) {}
            ++i;
        }
        return result;
    }
}

