/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.InternalImage;
import org.eclipse.swt.internal.graphics.InternalImageFactory;

public class ImageFactory {
    private final Map cache = new HashMap();
    private final Object cacheLock = new Object();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static String getImagePath(Image image) {
        String result = null;
        if (image != null) {
            String resourceName = image.internalImage.getResourceName();
            result = RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    public Image findImage(String path) {
        return this.findImage(path, RWT.getResourceManager().getContextLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image findImage(String path, ClassLoader imageLoader) {
        Image result;
        Object object = this.cacheLock;
        synchronized (object) {
            result = (Image)this.cache.get(path);
            if (result == null) {
                result = this.createImage(path, imageLoader);
                this.cache.put(path, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image findImage(String path, InputStream inputStream) {
        Image result;
        Object object = this.cacheLock;
        synchronized (object) {
            result = (Image)this.cache.get(path);
            if (result == null) {
                result = this.createImage(null, path, inputStream);
                this.cache.put(path, result);
            }
        }
        return result;
    }

    public Image createImage(Device device, String key, InputStream inputStream) {
        InternalImageFactory internalImageFactory = RWTFactory.getInternalImageFactory();
        InternalImage internalImage = internalImageFactory.findInternalImage(key, inputStream);
        return ImageFactory.createImageInstance(device, internalImage);
    }

    private Image createImage(String path, ClassLoader imageLoader) {
        InputStream inputStream = ImageFactory.getInputStream(path, imageLoader);
        return this.createImage(null, path, inputStream);
    }

    private static Image createImageInstance(Device device, InternalImage internalImage) {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.internal.graphics.InternalImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] paramTypes = classArray;
        Object[] paramValues = new Object[]{device, internalImage};
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.swt.graphics.Image");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (Image)ClassUtil.newInstance(clazz3, paramTypes, paramValues);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream getInputStream(String path, ClassLoader imageLoader) {
        InputStream result;
        IResourceManager manager = RWT.getResourceManager();
        ClassLoader bufferedContextLoader = manager.getContextLoader();
        if (imageLoader != null) {
            manager.setContextLoader(imageLoader);
        }
        try {
            result = manager.getResourceAsStream(path);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            manager.setContextLoader(bufferedContextLoader);
            throw throwable;
        }
        {
            Object var5_7 = null;
            manager.setContextLoader(bufferedContextLoader);
            return result;
        }
    }
}

