/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;

public class Decorator
extends Widget {
    public static final String KEY_DECORATIONS = "decorations";
    private Widget decoratedWidget;
    private DisposeListener disposeListener;

    public Decorator(Widget widget, int style) {
        super(widget, style);
        this.decoratedWidget = widget;
        this.registerDisposeListeners();
        this.bindDecoration();
    }

    protected final Widget getDecoratedWidget() {
        return this.decoratedWidget;
    }

    private void registerDisposeListeners() {
        this.disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                Decorator.this.release();
            }
        };
        this.addDisposeListener(this.disposeListener);
        this.decoratedWidget.addDisposeListener(this.disposeListener);
    }

    private void release() {
        if (this.decoratedWidget != null && !this.decoratedWidget.isDisposed()) {
            this.removeDisposeListener(this.disposeListener);
            this.decoratedWidget.removeDisposeListener(this.disposeListener);
            this.disposeListener = null;
            this.unbindDecoration();
            this.decoratedWidget = null;
            this.dispose();
        }
    }

    private void bindDecoration() {
        ArrayList<Decorator> decorations = (ArrayList<Decorator>)this.decoratedWidget.getData(KEY_DECORATIONS);
        if (decorations == null) {
            decorations = new ArrayList<Decorator>();
        }
        decorations.add(this);
        this.decoratedWidget.setData(KEY_DECORATIONS, decorations);
    }

    private void unbindDecoration() {
        List decorations = (List)this.decoratedWidget.getData(KEY_DECORATIONS);
        if (decorations != null) {
            decorations.remove(this);
            if (decorations.size() == 0) {
                decorations = null;
            }
            this.decoratedWidget.setData(KEY_DECORATIONS, decorations);
        }
    }
}

