/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.TreeTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeTab
extends ExampleTab {
    private static final int INITIAL_COLUMNS = 5;
    private static final int INITIAL_ITEMS = 15;
    private boolean headerVisible = true;
    private boolean linesVisible;
    private boolean updateVirtualItemsDelayed;
    private Tree tree;
    private boolean showImages = true;
    private final Image treeImage = Graphics.getImage((String)"resources/tree_item.gif", (ClassLoader)this.getClass().getClassLoader());
    private boolean addMouseListener;

    public TreeTab(CTabFolder topFolder) {
        super(topFolder, "Tree");
    }

    protected void createStyleControls(final Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("CHECK", 32);
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("VIRTUAL", 0x10000000);
        this.createStyleButton("FULL_SELECTION", 65536);
        this.createStyleButton("NO_SCROLL", 16);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createHeaderVisibleButton();
        this.createLinesVisibleButton();
        this.createImagesButton(parent);
        this.createAddNodeButton(parent);
        this.createDisposeNodeButton(parent);
        this.createSelectAllButton(parent);
        this.createDeselectAllButton(parent);
        this.createSelectButton(parent);
        this.createDeselectButton(parent);
        this.createSetSelectionButton(parent);
        this.createChangeItemCountControl();
        this.createShowColumnControl();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        final Button itemFgButton = this.createPropertyButton("Custom foreground on 1st item", 32);
        itemFgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = TreeTab.this.tree.getItem(0);
                Display display = parent.getDisplay();
                Color green = display.getSystemColor(5);
                item.setForeground((Color)(itemFgButton.getSelection() ? green : null));
            }
        });
        final Button itemBgButton = this.createPropertyButton("Custom background on 1st item", 32);
        itemBgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = TreeTab.this.tree.getItem(0);
                Display display = parent.getDisplay();
                Color red = display.getSystemColor(4);
                item.setBackground((Color)(itemBgButton.getSelection() ? red : null));
            }
        });
        final Button itemGrayButton2 = this.createPropertyButton("Gray out 2nd item", 32);
        itemGrayButton2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeTab.this.tree.getItem(1).setGrayed(itemGrayButton2.getSelection());
            }
        });
        Button columnsAlignmentButton = this.createPropertyButton("Change columns alignment", 8);
        columnsAlignmentButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeColumn col1 = TreeTab.this.tree.getColumn(1);
                if (col1.getAlignment() == 131072) {
                    col1.setAlignment(16384);
                } else {
                    col1.setAlignment(131072);
                }
                TreeColumn col2 = TreeTab.this.tree.getColumn(2);
                if (col2.getAlignment() == 0x1000000) {
                    col2.setAlignment(16384);
                } else {
                    col2.setAlignment(0x1000000);
                }
            }
        });
        Button cbAddMouseListener = new Button(parent, 32);
        cbAddMouseListener.setText("Attach MouseListener");
        cbAddMouseListener.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeTab.this.addMouseListener = !TreeTab.this.addMouseListener;
                TreeTab.this.createNew();
            }
        });
        cbAddMouseListener.setSelection(this.addMouseListener);
        Button getTopItemButton = this.createPropertyButton("Query topItem", 8);
        getTopItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem item = TreeTab.this.tree.getTopItem();
                String message = "Current topItem: " + item.toString();
                MessageDialog.openInformation((Shell)TreeTab.this.tree.getShell(), (String)"Information", (String)message);
            }
        });
        Button setTopItemButton = this.createPropertyButton("Set selection as topItem", 8);
        setTopItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem[] item = TreeTab.this.tree.getSelection();
                if (item.length > 0) {
                    TreeTab.this.tree.setTopItem(item[0]);
                }
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        int style = this.getStyle();
        this.tree = new Tree(parent, style);
        if ((style & 0x10000000) != 0) {
            this.tree.addListener(36, new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 36) {
                        if (TreeTab.this.updateVirtualItemsDelayed) {
                            Display display = event.display;
                            Job job = new Job(this, "Delayed Tree Item Update", display, event){
                                final /* synthetic */ 8 this$1;
                                private final /* synthetic */ Display val$display;
                                private final /* synthetic */ Event val$event;
                                {
                                    this.this$1 = var1_1;
                                    this.val$display = display;
                                    this.val$event = event;
                                }

                                protected IStatus run(IProgressMonitor monitor) {
                                    this.val$display.asyncExec(new Runnable(this, this.val$event){
                                        final /* synthetic */ 9 this$2;
                                        private final /* synthetic */ Event val$event;
                                        {
                                            this.this$2 = var1_1;
                                            this.val$event = event;
                                        }

                                        public void run() {
                                            TreeTab.access$4(8.access$0(9.access$0(this.this$2)), (TreeItem)this.val$event.item);
                                        }
                                    });
                                    return Status.OK_STATUS;
                                }

                                static /* synthetic */ 8 access$0(9 var0) {
                                    return var0.this$1;
                                }
                            };
                            job.schedule(1000L);
                        } else {
                            TreeTab.this.updateItem((TreeItem)event.item);
                        }
                    }
                }

                static /* synthetic */ TreeTab access$0(8 var0) {
                    return var0.TreeTab.this;
                }
            });
        }
        this.tree.setLayoutData((Object)new GridData(1808));
        int i = 0;
        while (i < 5) {
            TreeColumn col1 = new TreeColumn(this.tree, 0);
            col1.setText("Col " + i);
            col1.setWidth(150);
            ++i;
        }
        i = 0;
        while (i < 15) {
            TreeItem item = new TreeItem(this.tree, 0);
            int j = 0;
            while (j < 5) {
                item.setText(j, "Node_" + i + "." + j);
                ++j;
            }
            if (i % 2 == 0) {
                TreeItem subitem = new TreeItem(item, 0);
                int j2 = 0;
                while (j2 < 5) {
                    subitem.setText(j2, "Subnode_" + i + "." + j2);
                    ++j2;
                }
            }
            ++i;
        }
        if (this.showImages) {
            TreeTab.changeImage(this.tree, this.treeImage);
        }
        final Label lblTreeEvent = new Label(parent, 0);
        lblTreeEvent.setLayoutData((Object)new GridData(300, 22));
        Menu treeMenu = new Menu((Control)this.tree);
        MenuItem treeMenuItem = new MenuItem(treeMenu, 8);
        treeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeItem item = TreeTab.this.tree.getSelection()[0];
                String itemText = "null";
                if (item != null) {
                    itemText = item.getText();
                }
                String message = "You requested a context menu for: " + itemText;
                MessageDialog.openInformation((Shell)TreeTab.this.tree.getShell(), (String)"Information", (String)message);
            }
        });
        treeMenuItem.setText("TreeContextMenuItem");
        this.tree.setMenu(treeMenu);
        this.tree.addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent event) {
                Item item = (Item)event.item;
                lblTreeEvent.setText("Collapsed: " + item.getText());
            }

            public void treeExpanded(TreeEvent event) {
                Item item = (Item)event.item;
                lblTreeEvent.setText("Expanded: " + item.getText());
            }
        });
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String msg = "Selected: ";
                TreeItem item = (TreeItem)event.item;
                if ((TreeTab.this.getStyle() & 0x20) != 0) {
                    msg = String.valueOf(msg) + (item.getChecked() ? "[x] " : "[ ] ");
                }
                msg = String.valueOf(msg) + item.getText();
                switch (event.detail) {
                    case 0: {
                        msg = String.valueOf(msg) + ", detail: SWT.NONE";
                        break;
                    }
                    case 32: {
                        msg = String.valueOf(msg) + ", detail: SWT.CHECK";
                    }
                }
                lblTreeEvent.setText(msg);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                String title = "Widget Default Selected";
                Item item = (Item)event.item;
                String message = "Widget default selected on " + item.getText() + " received";
                MessageDialog.openInformation((Shell)TreeTab.this.getShell(), (String)title, (String)message);
            }
        });
        this.tree.setSelection(this.tree.getItem(0));
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(this.linesVisible);
        if (this.addMouseListener) {
            MouseListener listener = new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    TreeTab.this.log("mouseDoubleClick: " + e);
                }

                public void mouseDown(MouseEvent e) {
                    TreeTab.this.log("mouseDown: " + e);
                }

                public void mouseUp(MouseEvent e) {
                    TreeTab.this.log("mouseUp: " + e);
                }
            };
            this.tree.addMouseListener(listener);
        }
        this.registerControl((Control)this.tree);
    }

    private void updateItem(TreeItem item) {
        String text;
        int columns = item.getParent().getColumnCount();
        int index = -1;
        index = item.getParentItem() == null ? item.getParent().indexOf(item) : item.getParentItem().indexOf(item);
        String string = text = item.getParentItem() == null ? "Node_" : "Subnode_";
        if (columns == 0) {
            item.setText(String.valueOf(text) + index);
            if (this.showImages) {
                item.setImage(this.treeImage);
            }
        } else {
            int i = 0;
            while (i < columns) {
                item.setText(i, String.valueOf(text) + index + "." + i);
                if (i < 2 && this.showImages) {
                    item.setImage(i, this.treeImage);
                }
                ++i;
            }
        }
    }

    private void createHeaderVisibleButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("headerVisible");
        button.setSelection(this.headerVisible);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.headerVisible = button.getSelection();
                TreeTab.this.tree.setHeaderVisible(TreeTab.this.headerVisible);
            }
        });
    }

    private void createLinesVisibleButton() {
        final Button button = new Button(this.styleComp, 32);
        button.setText("linesVisible");
        button.setSelection(this.linesVisible);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.linesVisible = button.getSelection();
                TreeTab.this.tree.setLinesVisible(TreeTab.this.linesVisible);
            }
        });
    }

    private void createImagesButton(Composite parent) {
        final Button button = new Button(parent, 2);
        button.setText("Show Images");
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.showImages = button.getSelection();
                TreeTab.changeImage(TreeTab.this.tree, TreeTab.this.showImages ? TreeTab.this.treeImage : null);
            }
        });
    }

    private void createAddNodeButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Add child item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getSelectionCount() > 0) {
                    TreeItem selection = TreeTab.this.tree.getSelection()[0];
                    TreeItem treeItem = new TreeItem(selection, 0);
                    Object[] args = new Object[]{new Integer(selection.getItemCount()), selection.getText()};
                    String text = MessageFormat.format("SubItem {0} of {1}", args);
                    treeItem.setText(text);
                    treeItem.setChecked(true);
                    if (TreeTab.this.showImages) {
                        treeItem.setImage(TreeTab.this.treeImage);
                    }
                }
            }
        });
    }

    private void createDisposeNodeButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Dispose Selected Item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getSelectionCount() > 0) {
                    TreeItem selection = TreeTab.this.tree.getSelection()[0];
                    selection.dispose();
                }
            }
        });
    }

    private void createSelectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.tree.selectAll();
            }
        });
    }

    private void createDeselectAllButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect All");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.tree.deselectAll();
            }
        });
    }

    private void createSelectButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select second node");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getItemCount() > 1) {
                    TreeTab.this.tree.select(TreeTab.this.tree.getItem(1));
                }
            }
        });
    }

    private void createDeselectButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect second node");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getItemCount() > 1) {
                    TreeTab.this.tree.deselect(TreeTab.this.tree.getItem(1));
                }
            }
        });
    }

    private void createSetSelectionButton(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Set selection to first node");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (TreeTab.this.tree.getItemCount() > 0) {
                    TreeTab.this.tree.setSelection(TreeTab.this.tree.getItem(0));
                }
            }
        });
    }

    private void createShowColumnControl() {
        Composite composite = new Composite(this.styleComp, 0);
        RowLayout layout = new RowLayout(256);
        layout.center = true;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText("Column");
        final Text text = new Text(composite, 2048);
        Util.textSizeAdjustment(label, (Control)text);
        text.setText(String.valueOf(this.tree.getColumnCount() - 1));
        Button button = new Button(composite, 8);
        button.setText("Show");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int index = Integer.parseInt(text.getText());
                    TreeColumn column = TreeTab.this.tree.getColumn(index);
                    TreeTab.this.tree.showColumn(column);
                }
                catch (Exception exception) {}
            }
        });
    }

    private void createChangeItemCountControl() {
        Composite composite = new Composite(this.styleComp, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblItemCount = new Label(composite, 0);
        lblItemCount.setText("ItemCount");
        final Text txtItemCount = new Text(composite, 2048);
        Util.textSizeAdjustment(lblItemCount, (Control)txtItemCount);
        txtItemCount.setText(String.valueOf(this.tree.getItemCount()));
        Button btnChange = new Button(composite, 8);
        btnChange.setText("Change");
        btnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int itemCount = -1;
                try {
                    itemCount = Integer.parseInt(txtItemCount.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                TreeItem[] selectedItems = TreeTab.this.tree.getSelection();
                if (selectedItems.length > 0) {
                    selectedItems[0].setItemCount(itemCount);
                } else {
                    TreeTab.this.tree.setItemCount(itemCount);
                }
                TreeTab.this.tree.redraw();
            }
        });
        final Button cbDelayedUpdate = new Button(composite, 32);
        GridData gridData = new GridData(16384, 0x1000000, true, false, 3, -1);
        cbDelayedUpdate.setLayoutData((Object)gridData);
        cbDelayedUpdate.setText("Update virtual items delayed");
        cbDelayedUpdate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TreeTab.this.updateVirtualItemsDelayed = cbDelayedUpdate.getSelection();
            }
        });
    }

    private static void changeImage(Tree tree, Image image) {
        TreeItem[] items = tree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeTab.changeImage(items[i], image);
            ++i;
        }
    }

    private static void changeImage(TreeItem item, Image image) {
        item.setImage(0, image);
        if (item.getParent().getColumnCount() > 1) {
            item.setImage(1, image);
        }
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            TreeTab.changeImage(items[i], image);
            ++i;
        }
    }
}

