/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tabitemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;

public class TabItemLCA
extends AbstractWidgetLCA {
    private static final String PROP_SELECTED = "selected";
    private static final String JS_FUNC_TAB_SELECTED = "org.eclipse.swt.TabUtil.tabSelected";
    private static final String QX_EVENT_CHANGE_CHECKED = "changeChecked";

    public void preserveValues(Widget widget) {
        TabItem item = (TabItem)widget;
        ItemLCAUtil.preserve((Item)item);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_SELECTED, (Object)this.isSelected(item));
        WidgetLCAUtil.preserveToolTipText((Widget)item, item.getToolTipText());
        WidgetLCAUtil.preserveCustomVariant((Widget)item);
    }

    public void readData(Widget widget) {
        final TabItem item = (TabItem)widget;
        if (WidgetLCAUtil.wasEventSent((Widget)item, "org.eclipse.swt.events.widgetSelected.item")) {
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    TabFolder folder = item.getParent();
                    folder.setSelection(item);
                    ControlLCAUtil.processSelection((Widget)folder, (Item)item, false);
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        TabItem tabItem = (TabItem)widget;
        JSWriter writer = JSWriter.getWriterFor(widget);
        TabFolder parent = tabItem.getParent();
        Object[] args = new Object[]{WidgetUtil.getId((Widget)tabItem), WidgetUtil.getId((Widget)parent), new Integer(parent.indexOf(tabItem))};
        writer.callStatic("org.eclipse.swt.TabUtil.createTabItem", args);
        writer.addListener(QX_EVENT_CHANGE_CHECKED, JS_FUNC_TAB_SELECTED);
    }

    public void renderChanges(Widget widget) throws IOException {
        TabItem tabItem = (TabItem)widget;
        TabItemLCA.setJSParent(tabItem);
        ItemLCAUtil.writeChanges((Item)tabItem);
        this.writeSelection(tabItem);
        WidgetLCAUtil.writeToolTip((Widget)tabItem, tabItem.getToolTipText());
        WidgetLCAUtil.writeCustomVariant((Widget)tabItem);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.removeListener(QX_EVENT_CHANGE_CHECKED, JS_FUNC_TAB_SELECTED);
        Object[] args = new Object[]{WidgetUtil.getId((Widget)widget)};
        writer.callStatic("org.eclipse.swt.TabUtil.releaseTabItem", args);
        writer.dispose();
    }

    private void writeSelection(TabItem item) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)item);
        Boolean newValue = this.isSelected(item);
        writer.set(PROP_SELECTED, "checked", newValue, Boolean.FALSE);
    }

    private boolean isSelected(TabItem tabItem) {
        TabFolder parent = tabItem.getParent();
        int selectionIndex = parent.getSelectionIndex();
        return selectionIndex != -1 && parent.getItem(selectionIndex) == tabItem;
    }

    private static void setJSParent(TabItem tabItem) {
        Control control = tabItem.getControl();
        if (control != null) {
            StringBuffer replacementId = new StringBuffer();
            replacementId.append(WidgetUtil.getId((Widget)tabItem));
            replacementId.append("pg");
            WidgetAdapter controlAdapter = (WidgetAdapter)WidgetUtil.getAdapter((Widget)control);
            controlAdapter.setJSParent(replacementId.toString());
        }
    }
}

