/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.IItemHolderAdapter;
import org.eclipse.swt.internal.widgets.ITreeItemAdapter;
import org.eclipse.swt.internal.widgets.IWidgetColorAdapter;
import org.eclipse.swt.internal.widgets.IWidgetFontAdapter;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class TreeItem
extends Item {
    private static final int EMPTY_PREFERED_WIDTH_BUFFER = -1;
    private final TreeItem parentItem;
    final Tree parent;
    private TreeItem[] items;
    int itemCount;
    private final ITreeItemAdapter treeItemAdapter;
    int index;
    private Font font;
    private boolean expanded;
    private boolean checked;
    private Color background;
    private Color foreground;
    private boolean grayed;
    private String[] texts;
    private Image[] images;
    Color[] cellForegrounds;
    Color[] cellBackgrounds;
    Font[] cellFonts;
    int depth;
    private boolean cached;
    int flatIndex;
    private int preferredWidthBuffer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public TreeItem(Tree parent, int style) {
        this(parent, null, style, parent == null ? 0 : parent.getItemCount(), true);
    }

    public TreeItem[] getCreatedItems() {
        TreeItem[] result;
        if (this.parent.isVirtual()) {
            int count = 0;
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    ++count;
                }
                ++i;
            }
            result = new TreeItem[count];
            count = 0;
            i = 0;
            while (i < this.itemCount) {
                if (this.items[i] != null) {
                    result[count] = this.items[i];
                    ++count;
                }
                ++i;
            }
        } else {
            result = new TreeItem[this.itemCount];
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public TreeItem(Tree parent, int style, int index) {
        this(parent, null, style, index, true);
    }

    public TreeItem(TreeItem parentItem, int style) {
        this(parentItem == null ? null : parentItem.parent, parentItem, style, parentItem == null ? 0 : parentItem.getItemCount(false), true);
    }

    public TreeItem(TreeItem parentItem, int style, int index) {
        this(parentItem == null ? null : parentItem.parent, parentItem, style, index, true);
    }

    TreeItem(Tree parent, TreeItem parentItem, int style, int index, boolean create) {
        super(parent, style);
        this.parent = parent;
        this.parentItem = parentItem;
        this.index = index;
        int columnCount = parent.columnHolder.size();
        this.texts = new String[columnCount];
        this.images = new Image[columnCount];
        this.treeItemAdapter = new TreeItemAdapter();
        if (parentItem != null) {
            this.depth = parentItem.depth + 1;
        }
        this.clearPreferredWidthBuffer();
        this.setEmpty();
        if (create) {
            int numberOfItems = parentItem != null ? parentItem.getItemCount(false) : parent.getItemCount();
            if (index < 0 || index > numberOfItems) {
                this.error(6);
            }
            if (parentItem != null) {
                parentItem.createItem(this, index);
            } else {
                parent.createItem(this, index);
            }
            parent.updateFlatIndices();
            parent.updateScrollBars();
        }
    }

    private void setEmpty() {
        this.items = new TreeItem[4];
    }

    private void createItem(TreeItem item, int index) {
        if (this.itemCount == this.items.length) {
            boolean small = this.isVisible();
            int length = small ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TreeItem[] newItems = new TreeItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
        this.adjustItemIndices(index);
    }

    private void destroyItem(TreeItem item, int index) {
        --this.itemCount;
        if (this.itemCount == 0) {
            this.setEmpty();
        } else {
            System.arraycopy(this.items, index + 1, this.items, index, this.itemCount - index);
            this.items[this.itemCount] = null;
        }
        this.adjustItemIndices(index);
    }

    private void adjustItemIndices(int start) {
        int i = start;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].index = i;
            }
            ++i;
        }
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IItemHolderAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            result = new CompositeItemHolder();
        } else {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetFontAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz2) {
                result = this.treeItemAdapter;
            } else {
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.eclipse.swt.internal.widgets.IWidgetColorAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (adapter == clazz3) {
                    result = this.treeItemAdapter;
                } else {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("org.eclipse.swt.internal.widgets.ITreeItemAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    result = adapter == clazz4 ? this.treeItemAdapter : super.getAdapter(adapter);
                }
            }
        }
        return result;
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.markCached();
        if (!expanded || this.getItemCount() > 0) {
            this.expanded = expanded;
            this.parent.updateFlatIndices();
            this.parent.updateScrollBars();
            this.parent.checkAllData();
        }
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.getBounds(0);
    }

    public Rectangle getBounds(int columnIndex) {
        this.checkWidget();
        return this.getBounds(columnIndex, true);
    }

    Rectangle getBounds(int columnIndex, boolean checkData) {
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (this.isVisible() && this.isValidColumn(columnIndex)) {
            int left = this.parent.getVisualCellLeft(columnIndex, this);
            int width = this.parent.getVisualCellWidth(columnIndex, this, checkData);
            result = new Rectangle(left, this.getItemTop(), width, this.parent.getItemHeight());
        }
        return result;
    }

    private boolean isValidColumn(int index) {
        int columnCount = this.parent.getColumnCount();
        return columnCount == 0 && index == 0 || index >= 0 && index < columnCount;
    }

    private boolean isVisible() {
        return this.getParentItem() == null || this.getParentItem().getExpanded();
    }

    int getItemTop() {
        int headerHeight = this.parent.getHeaderHeight();
        int itemHeight = this.parent.getItemHeight();
        return headerHeight + (this.flatIndex - this.parent.getTopIndex()) * itemHeight;
    }

    public Color getBackground(int columnIndex) {
        this.checkWidget();
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getBackground();
        }
        if (this.cellBackgrounds == null || this.cellBackgrounds[columnIndex] == null) {
            return this.getBackground();
        }
        return this.cellBackgrounds[columnIndex];
    }

    public Font getFont(int columnIndex) {
        this.checkWidget();
        return this.getFont(columnIndex, true);
    }

    Font getFont(int columnIndex, boolean checkData) {
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getFont(checkData);
        }
        if (this.cellFonts == null || this.cellFonts[columnIndex] == null) {
            return this.getFont(checkData);
        }
        if (checkData) {
            this.materialize();
        }
        return this.cellFonts[columnIndex];
    }

    public Color getForeground(int columnIndex) {
        this.checkWidget();
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return this.getForeground();
        }
        if (this.cellForegrounds == null || this.cellForegrounds[columnIndex] == null) {
            return this.getForeground();
        }
        return this.cellForegrounds[columnIndex];
    }

    public void setBackground(int columnIndex, Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellBackgrounds == null) {
            this.cellBackgrounds = new Color[validColumnCount];
        } else if (this.cellBackgrounds.length < validColumnCount) {
            Color[] newCellBackgrounds = new Color[validColumnCount];
            System.arraycopy(this.cellBackgrounds, 0, newCellBackgrounds, 0, this.cellBackgrounds.length);
            this.cellBackgrounds = newCellBackgrounds;
        }
        if (this.cellBackgrounds[columnIndex] == value) {
            return;
        }
        if (this.cellBackgrounds[columnIndex] != null && this.cellBackgrounds[columnIndex].equals(value)) {
            return;
        }
        this.cellBackgrounds[columnIndex] = value;
        this.markCached();
    }

    public void setFont(int columnIndex, Font value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellFonts == null) {
            if (value == null) {
                return;
            }
            this.cellFonts = new Font[validColumnCount];
        } else if (this.cellFonts.length < validColumnCount) {
            Font[] newCellFonts = new Font[validColumnCount];
            System.arraycopy(this.cellFonts, 0, newCellFonts, 0, this.cellFonts.length);
            this.cellFonts = newCellFonts;
        }
        if (this.cellFonts[columnIndex] == value) {
            return;
        }
        if (this.cellFonts[columnIndex] != null && this.cellFonts[columnIndex].equals(value)) {
            return;
        }
        this.cellFonts[columnIndex] = value;
        this.markCached();
    }

    public void setForeground(int columnIndex, Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (this.cellForegrounds == null) {
            this.cellForegrounds = new Color[validColumnCount];
        } else if (this.cellForegrounds.length < validColumnCount) {
            Color[] newCellForegrounds = new Color[validColumnCount];
            System.arraycopy(this.cellForegrounds, 0, newCellForegrounds, 0, this.cellForegrounds.length);
            this.cellForegrounds = newCellForegrounds;
        }
        if (this.cellForegrounds[columnIndex] == value) {
            return;
        }
        if (this.cellForegrounds[columnIndex] != null && this.cellForegrounds[columnIndex].equals(value)) {
            return;
        }
        this.cellForegrounds[columnIndex] = value;
        if (this.parent.isVirtual()) {
            this.cached = true;
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
        this.markCached();
    }

    public Font getFont() {
        this.checkWidget();
        return this.getFont(true);
    }

    Font getFont(boolean checkData) {
        if (checkData) {
            this.materialize();
        }
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public void setBackground(Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        if (this.background == value) {
            return;
        }
        if (this.background != null && this.background.equals(value)) {
            return;
        }
        this.background = value;
        this.markCached();
    }

    public Color getBackground() {
        this.checkWidget();
        if (this.isDisposed()) {
            this.error(24);
        }
        this.materialize();
        if (this.background != null) {
            return this.background;
        }
        return this.parent.getBackground();
    }

    public Color getForeground() {
        this.checkWidget();
        if (this.isDisposed()) {
            this.error(24);
        }
        this.materialize();
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent.getForeground();
    }

    public void setForeground(Color value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        if (!(this.foreground == value || this.foreground != null && this.foreground.equals(value))) {
            this.foreground = value;
            this.markCached();
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) != 0 && checked != this.checked) {
            this.checked = checked;
            this.markCached();
        }
    }

    public boolean getChecked() {
        this.checkWidget();
        this.materialize();
        return this.checked;
    }

    public void setGrayed(boolean value) {
        this.checkWidget();
        if ((this.parent.getStyle() & 0x20) != 0 && this.grayed != value) {
            this.grayed = value;
            this.markCached();
        }
    }

    public boolean getGrayed() {
        this.checkWidget();
        this.materialize();
        return this.grayed;
    }

    public String getText(int columnIndex) {
        this.checkWidget();
        return this.getText(columnIndex, true);
    }

    public String getText() {
        this.checkWidget();
        this.materialize();
        return super.getText();
    }

    String getText(int columnIndex, boolean checkData) {
        if (checkData && !this.isCached()) {
            this.parent.checkData(this, this.index);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return "";
        }
        if (columnIndex == 0) {
            return super.getText();
        }
        if (this.texts[columnIndex] == null) {
            return "";
        }
        return this.texts[columnIndex];
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (this.isVisible() && this.isValidColumn(index)) {
            result.x = this.parent.getVisualTextLeft(index, this);
            result.y = this.getItemTop();
            result.width = this.parent.getVisualTextWidth(index, this);
            result.height = this.parent.getItemHeight();
        }
        return result;
    }

    public void setText(String[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setText(i, value[i]);
            }
            ++i;
        }
    }

    public void setText(int columnIndex, String value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        if (value.equals(this.getText(columnIndex, false))) {
            return;
        }
        if (columnIndex == 0) {
            super.setText(value);
        } else {
            this.texts[columnIndex] = value;
        }
        this.clearPreferredWidthBuffer();
        if (this.parent.getColumnCount() == 0) {
            this.parent.updateScrollBars();
        }
        this.markCached();
    }

    public void setText(String text) {
        this.checkWidget();
        this.setText(0, text);
    }

    public Image getImage(int columnIndex) {
        this.checkWidget();
        return this.getImage(columnIndex, true);
    }

    public Image getImage() {
        return this.getImage(0);
    }

    public Rectangle getImageBounds(int columnIndex) {
        this.checkWidget();
        Rectangle result = null;
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex >= 0 && columnIndex < validColumnCount) {
            result = new Rectangle(0, 0, 0, 0);
            Point size = this.parent.getItemImageSize(columnIndex);
            result.width = size.x;
            result.height = size.y;
            result.x = this.parent.getVisualCellLeft(columnIndex, this);
            result.x += this.parent.getCellPadding().x;
            result.y = this.getItemTop();
        } else {
            result = new Rectangle(0, 0, 0, 0);
        }
        return result;
    }

    Image getImage(int columnIndex, boolean checkData) {
        int validColumnCount = Math.max(1, this.parent.columnHolder.size());
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return null;
        }
        if (checkData) {
            this.materialize();
        }
        if (columnIndex == 0) {
            return super.getImage();
        }
        return this.images[columnIndex];
    }

    int getPreferredWidth(int columnIndex, boolean checkData) {
        return this.parent.getPreferredCellWidth(this, columnIndex, checkData);
    }

    void clear() {
        this.checked = false;
        this.grayed = false;
        this.texts = null;
        this.images = null;
        this.background = null;
        this.foreground = null;
        this.cellBackgrounds = null;
        this.cellForegrounds = null;
        this.font = null;
        this.cellFonts = null;
        this.setText("");
        this.setImage((Image)null);
        int columnCount = this.parent.columnHolder.size();
        if (columnCount > 0 && columnCount > 1) {
            this.texts = new String[columnCount];
            this.images = new Image[columnCount];
        }
        this.clearCached();
        this.parent.updateScrollBars();
    }

    public void clear(int index, boolean recursive) {
        TreeItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.clear();
            if (recursive) {
                item.clearAll(true, false);
            }
        }
    }

    void addColumn(TreeColumn column) {
        int index = column.getIndex();
        int columnCount = this.parent.columnHolder.size();
        if (columnCount > 1) {
            if (columnCount == 2) {
                this.texts = new String[2];
            } else {
                String[] newTexts = new String[columnCount];
                System.arraycopy(this.texts, 0, newTexts, 0, index);
                System.arraycopy(this.texts, index, newTexts, index + 1, columnCount - index - 1);
                this.texts = newTexts;
            }
            if (index == 0) {
                this.texts[1] = this.text;
                this.text = "";
            }
            if (columnCount == 2) {
                this.images = new Image[2];
            } else {
                Image[] newImages = new Image[columnCount];
                System.arraycopy(this.images, 0, newImages, 0, index);
                System.arraycopy(this.images, index, newImages, index + 1, columnCount - index - 1);
                this.images = newImages;
            }
            if (index == 0) {
                this.images[1] = this.image;
                this.image = null;
            }
        }
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.addColumn(column);
            }
            ++i;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImage(int columnIndex, Image value) {
        this.checkWidget();
        if (value != null && value.isDisposed()) {
            this.error(5);
        }
        TreeColumn[] columns = (TreeColumn[])this.parent.columnHolder.getItems();
        int validColumnCount = Math.max(1, columns.length);
        if (columnIndex < 0 || columnIndex >= validColumnCount) {
            return;
        }
        Image image = this.getImage(columnIndex, false);
        if (value == image) {
            return;
        }
        if (value != null && value.equals(image)) {
            return;
        }
        this.parent.updateColumnImageCount(columnIndex, image, value);
        this.parent.updateItemImageSize(value);
        if (columnIndex == 0) {
            super.setImage(value);
        } else {
            this.images[columnIndex] = value;
        }
        this.markCached();
        this.clearPreferredWidthBuffer();
        if (this.parent.getColumnCount() == 0) {
            this.parent.updateScrollBars();
        }
    }

    public void setImage(Image[] value) {
        this.checkWidget();
        if (value == null) {
            this.error(4);
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] != null && value[i].isDisposed()) {
                this.error(5);
            }
            ++i;
        }
        i = 0;
        while (i < value.length) {
            if (value[i] != null) {
                this.setImage(i, value[i]);
            }
            ++i;
        }
    }

    public void clearAll(boolean recursive) {
        this.clearAll(recursive, true);
    }

    void clearAll(boolean recursive, boolean doVisualUpdate) {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null) {
                item.clear();
                if (recursive) {
                    item.clearAll(true, false);
                }
                this.parent.checkData(item, item.index);
            }
            ++i;
        }
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.itemCount];
        if (this.parent.isVirtual()) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    private TreeItem _getItem(int index) {
        if (this.parent.isVirtual() && this.items[index] == null) {
            this.items[index] = new TreeItem(this.parent, this, 0, index, false);
        }
        return this.items[index];
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        return this._getItem(index);
    }

    public int getItemCount() {
        return this.getItemCount(true);
    }

    int getItemCount(boolean checkData) {
        this.checkWidget();
        if (checkData) {
            this.materialize();
        }
        return this.itemCount;
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
        return item.parentItem == this ? item.index : -1;
    }

    public void removeAll() {
        this.checkWidget();
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        int oldItemCount = this.getItemCount(false);
        int newItemCount = Math.max(0, count);
        if (newItemCount != oldItemCount) {
            int index = oldItemCount - 1;
            while (index >= newItemCount) {
                TreeItem item = this.items[index];
                if (item != null && !item.isDisposed()) {
                    item.dispose();
                }
                --index;
            }
            int length = Math.max(4, (newItemCount + 3) / 4 * 4);
            TreeItem[] newItems = new TreeItem[length];
            System.arraycopy(this.items, 0, newItems, 0, Math.min(newItemCount, this.itemCount));
            this.items = newItems;
            if (!this.parent.isVirtual()) {
                int i = oldItemCount;
                while (i < newItemCount) {
                    new TreeItem(this, 0, i);
                    ++i;
                }
            }
            this.itemCount = newItemCount;
            this.parent.updateScrollBars();
        }
    }

    final void releaseChildren() {
        TreeItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].dispose();
            ++i;
        }
    }

    final void releaseParent() {
        if (this.parentItem != null) {
            this.parentItem.destroyItem(this, this.index);
        } else {
            this.parent.destroyItem(this, this.index);
        }
        if (!this.parent.isInDispose()) {
            this.parent.removeFromSelection(this);
            this.parent.updateScrollBars();
        }
        super.releaseParent();
    }

    void clearPreferredWidthBuffer() {
        this.preferredWidthBuffer = -1;
    }

    void setPreferredWidthBuffer(int preferredWidthBuffer) {
        this.preferredWidthBuffer = preferredWidthBuffer;
    }

    boolean hasPreferredWidthBuffer() {
        return this.preferredWidthBuffer != -1;
    }

    int getPreferredWidthBuffer() {
        return this.preferredWidthBuffer;
    }

    int getInnerHeight() {
        int innerHeight = this.getItemCount() * this.parent.getItemHeight();
        int i = 0;
        while (i < this.getItemCount()) {
            TreeItem item = this.getItem(i);
            if (item.getExpanded()) {
                innerHeight += item.getInnerHeight();
            }
            ++i;
        }
        return innerHeight;
    }

    private void materialize() {
        if (!this.isCached()) {
            this.parent.checkData(this, this.index);
        }
    }

    void markCached() {
        if (this.parent.isVirtual()) {
            this.cached = true;
        }
    }

    private void clearCached() {
        if (this.parent.isVirtual()) {
            this.cached = false;
        }
    }

    boolean isCached() {
        boolean result = true;
        if (this.parent.isVirtual()) {
            result = this.cached;
        }
        return result;
    }

    private final class CompositeItemHolder
    implements IItemHolderAdapter {
        private CompositeItemHolder() {
        }

        public void add(Item item) {
            throw new UnsupportedOperationException();
        }

        public void insert(Item item, int index) {
            throw new UnsupportedOperationException();
        }

        public void remove(Item item) {
            throw new UnsupportedOperationException();
        }

        public Item[] getItems() {
            TreeItem[] items = TreeItem.this.getCreatedItems();
            Item[] result = new Item[items.length];
            System.arraycopy(items, 0, result, 0, items.length);
            return result;
        }
    }

    private final class TreeItemAdapter
    implements ITreeItemAdapter,
    IWidgetFontAdapter,
    IWidgetColorAdapter {
        private TreeItemAdapter() {
        }

        public boolean isParentDisposed() {
            return TreeItem.this.parent.isDisposed();
        }

        public Color getUserBackgound() {
            return TreeItem.this.background;
        }

        public Color getUserForegound() {
            return TreeItem.this.foreground;
        }

        public Font getUserFont() {
            return TreeItem.this.font;
        }

        public Color[] getCellBackgrounds() {
            Color[] backgrounds = null;
            if (TreeItem.this.cellBackgrounds != null) {
                backgrounds = (Color[])TreeItem.this.cellBackgrounds.clone();
            }
            return backgrounds;
        }

        public Color[] getCellForegrounds() {
            Color[] foregrounds = null;
            if (TreeItem.this.cellForegrounds != null) {
                foregrounds = (Color[])TreeItem.this.cellForegrounds.clone();
            }
            return foregrounds;
        }

        public Font[] getCellFonts() {
            Font[] fonts = null;
            if (TreeItem.this.cellFonts != null) {
                fonts = (Font[])TreeItem.this.cellFonts.clone();
            }
            return fonts;
        }
    }
}

