/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.textsize;

import java.io.IOException;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.textsize.MeasurementItem;
import org.eclipse.rwt.internal.textsize.MeasurementOperator;
import org.eclipse.rwt.internal.textsize.Probe;
import org.eclipse.rwt.internal.textsize.TextSizeUtilFacade;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.graphics.FontData;

public final class TextSizeUtilFacadeImpl
extends TextSizeUtilFacade {
    private static final String FUNCTION_MEASURE_STRINGS = "org.eclipse.swt.FontSizeCalculation.measureStrings";
    private static final String FUNCTION_PROBE = "org.eclipse.swt.FontSizeCalculation.probe";

    public String getStartupProbeCodeInternal() {
        StringBuffer result = new StringBuffer();
        Probe[] probeList = RWTFactory.getProbeStore().getProbes();
        if (probeList.length > 0) {
            result.append(FUNCTION_PROBE);
            result.append("( [ ");
            int i = 0;
            while (i < probeList.length) {
                Probe probe = probeList[i];
                result.append(TextSizeUtilFacadeImpl.createProbeParamFragment(probe));
                result.append(this.getParamFragmentSeparator(i, probeList.length));
                ++i;
            }
            result.append(" ] );");
        }
        return result.toString();
    }

    public String createMeasurementStringInternal(String string, boolean expandNewLines) {
        String result = WidgetLCAUtil.escapeText(string, true);
        String newLineReplacement = expandNewLines ? "<br/>" : " ";
        return WidgetLCAUtil.replaceNewLines(result, newLineReplacement);
    }

    public void writeStringMeasurementsInternal() {
        MeasurementItem[] items = MeasurementOperator.getInstance().getItems();
        if (items.length > 0) {
            StringBuffer param = new StringBuffer();
            param.append("[ ");
            int i = 0;
            while (i < items.length) {
                param.append(TextSizeUtilFacadeImpl.createItemParamFragment(items[i]));
                param.append(this.getParamFragmentSeparator(i, items.length));
                ++i;
            }
            param.append(" ]");
            this.writeFunctionCall(FUNCTION_MEASURE_STRINGS, param);
        }
    }

    public void writeFontProbingInternal() {
        Probe[] requests = MeasurementOperator.getInstance().getProbes();
        if (requests.length > 0) {
            StringBuffer param = new StringBuffer();
            param.append("[ ");
            int i = 0;
            while (i < requests.length) {
                param.append(TextSizeUtilFacadeImpl.createProbeParamFragment(requests[i]));
                param.append(this.getParamFragmentSeparator(i, requests.length));
                ++i;
            }
            param.append(" ]");
            this.writeFunctionCall(FUNCTION_PROBE, param);
        }
    }

    static String createItemParamFragment(MeasurementItem item) {
        StringBuffer result = new StringBuffer();
        result.append("[ ");
        result.append(item.hashCode());
        result.append(", \"");
        String textToMeasure = item.getTextToMeasure();
        textToMeasure = EncodingUtil.escapeDoubleQuoted((String)textToMeasure);
        textToMeasure = EncodingUtil.escapeLeadingTrailingSpaces((String)textToMeasure);
        result.append(textToMeasure);
        result.append("\", ");
        result.append(TextSizeUtilFacadeImpl.createFontParam(item.getFontData()));
        result.append(", ");
        result.append(item.getWrapWidth());
        result.append(" ]");
        return result.toString();
    }

    static String createProbeParamFragment(Probe probe) {
        FontData fontData = probe.getFontData();
        StringBuffer result = new StringBuffer();
        result.append("[ ");
        result.append(fontData.hashCode());
        result.append(", \"");
        result.append(probe.getText());
        result.append("\", ");
        result.append(TextSizeUtilFacadeImpl.createFontParam(fontData));
        result.append(" ]");
        return result.toString();
    }

    private static String createFontParam(FontData fontData) {
        StringBuffer result = new StringBuffer();
        String[] names = WidgetLCAUtil.parseFontName(fontData.getName());
        result.append("[ ");
        int i = 0;
        while (i < names.length) {
            result.append("\"");
            result.append(names[i]);
            result.append("\"");
            if (i < names.length - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append(" ], ");
        result.append(fontData.getHeight());
        result.append(", ");
        result.append((fontData.getStyle() & 1) != 0);
        result.append(", ");
        result.append((fontData.getStyle() & 2) != 0);
        return result.toString();
    }

    private String getParamFragmentSeparator(int currentIndex, int lengthCount) {
        String result = "";
        if (this.isNotLast(currentIndex, lengthCount)) {
            result = ", ";
        }
        return result;
    }

    private boolean isNotLast(int currentIndex, int lengthCount) {
        return currentIndex < lengthCount - 1;
    }

    private void writeFunctionCall(String functionName, StringBuffer param) {
        try {
            this.getWriter().callStatic(functionName, new Object[]{new JSVar(param.toString())});
        }
        catch (IOException shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
    }

    private JSWriter getWriter() {
        return JSWriter.getWriterForResetHandler();
    }
}

