/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.demo.controls.Util;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextTab
extends ExampleTab {
    private Text text;
    private Label textLabel;
    private Label selectionLabel;
    private Button btnSelectionListener;
    private Button btnBlockingVerifyListener;
    private Button btnNumbersOnlyVerifyListener;
    private Button btnModifyListener;
    private Button btnEditable;
    private Button btnEchoChar;
    private final SelectionListener selectionListener = new SelectionAdapter(){

        public void widgetDefaultSelected(SelectionEvent event) {
            String msg = "You pressed the Enter key.";
            MessageDialog.openInformation((Shell)TextTab.this.getShell(), (String)"Information", (String)msg);
        }
    };
    private final VerifyListener blockingVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.doit = false;
        }
    };
    private final VerifyListener numberOnlyVerifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            StringBuffer allowedText = new StringBuffer();
            int i = 0;
            while (i < event.text.length()) {
                char ch = event.text.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    allowedText.append(ch);
                }
                ++i;
            }
            event.text = allowedText.toString();
        }
    };
    private final ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            Text text = (Text)event.widget;
            TextTab.this.textLabel.setText(text.getText());
        }
    };

    public TextTab(CTabFolder topFolder) {
        super(topFolder, "Text");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("WRAP", 64);
        this.createStyleButton("SINGLE", 4);
        this.createStyleButton("MULTI", 2);
        this.createStyleButton("PASSWORD", 0x400000);
        this.createStyleButton("SEARCH", 128);
        this.createStyleButton("READ_ONLY", 8);
        this.createStyleButton("LEFT", 16384);
        this.createStyleButton("CENTER", 0x1000000);
        this.createStyleButton("RIGHT", 131072);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createEditableButton();
        this.createEchoCharButton();
        this.createSelectionListenerButton();
        this.createBlockingVerifyListenerButton();
        this.createNumbersOnlyVerifyListenerButton();
        this.createModifyListenerButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createFontChooser();
        this.createCursorCombo();
        this.createLimitText(parent);
        this.createSelectionChooser(parent);
        this.createText(parent);
        this.createMessage(parent);
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        Composite textComposite = new Composite(parent, 0);
        textComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        textComposite.setLayout((Layout)new GridLayout(1, false));
        this.text = new Text(textComposite, this.getStyle());
        this.text.setText("Lorem ipsum dolor sit amet");
        this.text.setSelection(0, 5);
        this.text.setMessage("Please enter something");
        this.text.setFocus();
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setLayoutData((Object)new GridData(4, -1, true, false));
        buttonBar.setLayout((Layout)new RowLayout(256));
        Button btnGetText = new Button(buttonBar, 8);
        btnGetText.setText("getText");
        btnGetText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTab.this.textLabel.setText(TextTab.this.text.getText());
            }
        });
        Button btnGetSelection = new Button(buttonBar, 8);
        btnGetSelection.setText("getSelection");
        btnGetSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Point selection = TextTab.this.text.getSelection();
                TextTab.this.selectionLabel.setText(String.valueOf(selection.x) + ", " + selection.y);
            }
        });
        Button btnFixedSize = new Button(buttonBar, 8);
        btnFixedSize.setText("200 x 100");
        btnFixedSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTab.this.text.setLayoutData((Object)new GridData(200, 100));
                TextTab.this.text.getParent().layout();
            }
        });
        Composite outputForm = new Composite(parent, 0);
        outputForm.setLayoutData((Object)new GridData(4, 4, true, true));
        outputForm.setLayout((Layout)new GridLayout(2, false));
        new Label(outputForm, 0).setText("Text:");
        this.textLabel = new Label(outputForm, 2048);
        this.textLabel.setText("\n\n\n\n\n");
        this.textLabel.setLayoutData((Object)new GridData(4, -1, true, false));
        new Label(outputForm, 0).setText("Selection:");
        this.selectionLabel = new Label(outputForm, 2048);
        this.selectionLabel.setLayoutData((Object)new GridData(4, -1, true, false));
        this.updateSelectionListener();
        this.updateBlockingVerifyListener();
        this.updateNumbersOnlyVerifyListener();
        this.updateModifyListener();
        this.updateEditable();
        this.registerControl((Control)this.text);
        this.createDefaultButton(parent);
    }

    private void createDefaultButton(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        final Button defaultButton = new Button(composite, 8);
        defaultButton.setText("Default");
        defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String message = "Default button triggered";
                MessageDialog.openInformation((Shell)parent.getShell(), (String)"Info", (String)message);
            }
        });
        final Button setDefaultButton = new Button(composite, 32);
        setDefaultButton.setText("set as defaultButton");
        setDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (setDefaultButton.getSelection()) {
                    parent.getShell().setDefaultButton(defaultButton);
                } else {
                    parent.getShell().setDefaultButton(null);
                }
            }
        });
    }

    private void createModifyListenerButton() {
        this.btnModifyListener = this.createPropertyButton("ModifyListener");
        this.btnModifyListener.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTab.this.updateModifyListener();
            }
        });
    }

    private void createNumbersOnlyVerifyListenerButton() {
        this.btnNumbersOnlyVerifyListener = this.createPropertyButton("VerifyListener (numbers only)");
        this.btnNumbersOnlyVerifyListener.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTab.this.updateNumbersOnlyVerifyListener();
            }
        });
    }

    private void createBlockingVerifyListenerButton() {
        this.btnBlockingVerifyListener = this.createPropertyButton("VerifyListener (reject all)");
        this.btnBlockingVerifyListener.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTab.this.updateBlockingVerifyListener();
            }
        });
    }

    private void createSelectionListenerButton() {
        this.btnSelectionListener = this.createPropertyButton("SelectionListener");
        this.btnSelectionListener.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTab.this.updateSelectionListener();
            }
        });
    }

    private void createEditableButton() {
        this.btnEditable = this.createPropertyButton("Editable");
        this.btnEditable.setSelection(true);
        this.btnEditable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTab.this.updateEditable();
            }
        });
    }

    private void createEchoCharButton() {
        this.btnEchoChar = this.createPropertyButton("EchoChar");
        this.btnEchoChar.setSelection(false);
        this.btnEchoChar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextTab.this.updateEchoChar();
            }
        });
    }

    private void createSelectionChooser(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        Label lblSelectionFrom = new Label(composite, 0);
        lblSelectionFrom.setText("Selection from");
        final Text txtSelectionFrom = new Text(composite, 2048);
        Util.textSizeAdjustment(lblSelectionFrom, (Control)txtSelectionFrom);
        Label lblSelectionTo = new Label(composite, 0);
        lblSelectionTo.setText("to");
        final Text txtSelectionTo = new Text(composite, 2048);
        Util.textSizeAdjustment(lblSelectionTo, (Control)txtSelectionTo);
        Button btnChange = new Button(composite, 8);
        btnChange.setText("Set");
        btnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int from = TextTab.this.parseInt(txtSelectionFrom.getText());
                int to = TextTab.this.parseInt(txtSelectionTo.getText());
                if (to >= 0 && from >= 0) {
                    TextTab.this.text.setSelection(from, to);
                    TextTab.this.text.setFocus();
                } else {
                    String msg = "Invalid Selection: " + txtSelectionFrom.getText() + " - " + txtSelectionTo.getText();
                    MessageDialog.openError((Shell)TextTab.this.getShell(), (String)"Error", (String)msg);
                }
            }
        });
        Button selectAllButton = new Button(composite, 8);
        selectAllButton.setText("Select all");
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTab.this.text.selectAll();
                TextTab.this.text.setFocus();
            }
        });
    }

    private void createLimitText(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(composite, 0);
        label.setText("Text limit");
        final Text limitText = new Text(composite, 2048);
        limitText.setLayoutData((Object)new GridData(100, -1));
        Button setButton = new Button(composite, 8);
        setButton.setText("Set");
        Button resetButton = new Button(composite, 8);
        resetButton.setText("Reset");
        Listener changeListener = new Listener(){

            public void handleEvent(Event event) {
                try {
                    TextTab.this.text.setTextLimit(Integer.parseInt(limitText.getText()));
                    limitText.setText(String.valueOf(TextTab.this.text.getTextLimit()));
                    limitText.setBackground(null);
                }
                catch (Exception exception) {
                    limitText.setBackground(BG_COLOR_BROWN);
                }
            }
        };
        limitText.addListener(14, changeListener);
        setButton.addListener(13, changeListener);
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTab.this.text.setTextLimit(Integer.MAX_VALUE);
                limitText.setText("");
                limitText.setBackground(null);
            }
        });
    }

    private void createText(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Text");
        group.setLayout((Layout)new GridLayout(2, false));
        final Text setText = new Text((Composite)group, 2048);
        setText.setLayoutData((Object)new GridData(200, -1));
        Button setButton = new Button((Composite)group, 8);
        setButton.setText("Set");
        setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTab.this.text.setText(setText.getText());
            }
        });
        final Text appendText = new Text((Composite)group, 2048);
        appendText.setLayoutData((Object)new GridData(200, -1));
        Button appendButton = new Button((Composite)group, 8);
        appendButton.setText("Append");
        appendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTab.this.text.append(appendText.getText());
            }
        });
        final Text insertText = new Text((Composite)group, 2048);
        insertText.setLayoutData((Object)new GridData(200, -1));
        Button insertButton = new Button((Composite)group, 8);
        insertButton.setText("Insert");
        insertButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTab.this.text.insert(insertText.getText());
            }
        });
    }

    private void createMessage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText("Message");
        final Text message = new Text(composite, 2048);
        message.setLayoutData((Object)new GridData(185, -1));
        Button setButton = new Button(composite, 8);
        setButton.setText("Set");
        setButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTab.this.text.setMessage(message.getText());
            }
        });
    }

    private int parseInt(String text) {
        int result;
        try {
            result = Integer.parseInt(text);
        }
        catch (NumberFormatException numberFormatException) {
            result = -1;
        }
        return result;
    }

    private void updateSelectionListener() {
        if (this.btnSelectionListener != null) {
            if (this.btnSelectionListener.getSelection()) {
                this.text.addSelectionListener(this.selectionListener);
            } else {
                this.text.removeSelectionListener(this.selectionListener);
            }
        }
    }

    private void updateBlockingVerifyListener() {
        if (this.btnBlockingVerifyListener != null) {
            if (this.btnBlockingVerifyListener.getSelection()) {
                this.text.addVerifyListener(this.blockingVerifyListener);
            } else {
                this.text.removeVerifyListener(this.blockingVerifyListener);
            }
        }
    }

    private void updateNumbersOnlyVerifyListener() {
        if (this.btnNumbersOnlyVerifyListener != null) {
            if (this.btnNumbersOnlyVerifyListener.getSelection()) {
                this.text.addVerifyListener(this.numberOnlyVerifyListener);
            } else {
                this.text.removeVerifyListener(this.numberOnlyVerifyListener);
            }
        }
    }

    private void updateModifyListener() {
        if (this.btnModifyListener != null) {
            if (this.btnModifyListener.getSelection()) {
                this.text.addModifyListener(this.modifyListener);
            } else {
                this.text.removeModifyListener(this.modifyListener);
            }
        }
    }

    private void updateEditable() {
        if (this.btnEditable != null) {
            this.text.setEditable(this.btnEditable.getSelection());
        }
    }

    private void updateEchoChar() {
        if (this.btnEchoChar != null) {
            this.text.setEchoChar(this.btnEchoChar.getSelection() ? (char)'*' : '\u0000');
        }
    }
}

